/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.DiskImageDescription;
import software.amazon.awssdk.services.ec2.model.DiskImageVolumeDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportVolumeTaskDetails
implements ToCopyableBuilder<Builder, ImportVolumeTaskDetails> {
    private final String availabilityZone;
    private final Long bytesConverted;
    private final String description;
    private final DiskImageDescription image;
    private final DiskImageVolumeDescription volume;

    private ImportVolumeTaskDetails(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.bytesConverted = builder.bytesConverted;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long bytesConverted() {
        return this.bytesConverted;
    }

    public String description() {
        return this.description;
    }

    public DiskImageDescription image() {
        return this.image;
    }

    public DiskImageVolumeDescription volume() {
        return this.volume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesConverted());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.volume());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeTaskDetails)) {
            return false;
        }
        ImportVolumeTaskDetails other = (ImportVolumeTaskDetails)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.bytesConverted(), other.bytesConverted()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.volume(), other.volume());
    }

    public String toString() {
        return ToString.builder((String)"ImportVolumeTaskDetails").add("AvailabilityZone", (Object)this.availabilityZone()).add("BytesConverted", (Object)this.bytesConverted()).add("Description", (Object)this.description()).add("Image", (Object)this.image()).add("Volume", (Object)this.volume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "BytesConverted": {
                return Optional.ofNullable(clazz.cast(this.bytesConverted()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "Volume": {
                return Optional.ofNullable(clazz.cast(this.volume()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long bytesConverted;
        private String description;
        private DiskImageDescription image;
        private DiskImageVolumeDescription volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeTaskDetails model) {
            this.availabilityZone(model.availabilityZone);
            this.bytesConverted(model.bytesConverted);
            this.description(model.description);
            this.image(model.image);
            this.volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getBytesConverted() {
            return this.bytesConverted;
        }

        @Override
        public final Builder bytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
            return this;
        }

        public final void setBytesConverted(Long bytesConverted) {
            this.bytesConverted = bytesConverted;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDescription.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(DiskImageDescription image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDescription.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final DiskImageVolumeDescription.Builder getVolume() {
            return this.volume != null ? this.volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(DiskImageVolumeDescription volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(DiskImageVolumeDescription.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        public ImportVolumeTaskDetails build() {
            return new ImportVolumeTaskDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportVolumeTaskDetails> {
        public Builder availabilityZone(String var1);

        public Builder bytesConverted(Long var1);

        public Builder description(String var1);

        public Builder image(DiskImageDescription var1);

        default public Builder image(Consumer<DiskImageDescription.Builder> image) {
            return this.image((DiskImageDescription)((DiskImageDescription.Builder)DiskImageDescription.builder().applyMutation(image)).build());
        }

        public Builder volume(DiskImageVolumeDescription var1);

        default public Builder volume(Consumer<DiskImageVolumeDescription.Builder> volume) {
            return this.volume((DiskImageVolumeDescription)((DiskImageVolumeDescription.Builder)DiskImageVolumeDescription.builder().applyMutation(volume)).build());
        }
    }
}

