/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SnapshotDetail;
import software.amazon.awssdk.services.ec2.model.SnapshotDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportImageTask
implements ToCopyableBuilder<Builder, ImportImageTask> {
    private final String architecture;
    private final String description;
    private final String hypervisor;
    private final String imageId;
    private final String importTaskId;
    private final String licenseType;
    private final String platform;
    private final String progress;
    private final List<SnapshotDetail> snapshotDetails;
    private final String status;
    private final String statusMessage;

    private ImportImageTask(BuilderImpl builder) {
        this.architecture = builder.architecture;
        this.description = builder.description;
        this.hypervisor = builder.hypervisor;
        this.imageId = builder.imageId;
        this.importTaskId = builder.importTaskId;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.progress = builder.progress;
        this.snapshotDetails = builder.snapshotDetails;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public String architecture() {
        return this.architecture;
    }

    public String description() {
        return this.description;
    }

    public String hypervisor() {
        return this.hypervisor;
    }

    public String imageId() {
        return this.imageId;
    }

    public String importTaskId() {
        return this.importTaskId;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public String platform() {
        return this.platform;
    }

    public String progress() {
        return this.progress;
    }

    public List<SnapshotDetail> snapshotDetails() {
        return this.snapshotDetails;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageTask)) {
            return false;
        }
        ImportImageTask other = (ImportImageTask)obj;
        return Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hypervisor(), other.hypervisor()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.importTaskId(), other.importTaskId()) && Objects.equals(this.licenseType(), other.licenseType()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.snapshotDetails(), other.snapshotDetails()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"ImportImageTask").add("Architecture", (Object)this.architecture()).add("Description", (Object)this.description()).add("Hypervisor", (Object)this.hypervisor()).add("ImageId", (Object)this.imageId()).add("ImportTaskId", (Object)this.importTaskId()).add("LicenseType", (Object)this.licenseType()).add("Platform", (Object)this.platform()).add("Progress", (Object)this.progress()).add("SnapshotDetails", this.snapshotDetails()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Hypervisor": {
                return Optional.ofNullable(clazz.cast(this.hypervisor()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ImportTaskId": {
                return Optional.ofNullable(clazz.cast(this.importTaskId()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseType()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "SnapshotDetails": {
                return Optional.ofNullable(clazz.cast(this.snapshotDetails()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String architecture;
        private String description;
        private String hypervisor;
        private String imageId;
        private String importTaskId;
        private String licenseType;
        private String platform;
        private String progress;
        private List<SnapshotDetail> snapshotDetails = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageTask model) {
            this.architecture(model.architecture);
            this.description(model.description);
            this.hypervisor(model.hypervisor);
            this.imageId(model.imageId);
            this.importTaskId(model.importTaskId);
            this.licenseType(model.licenseType);
            this.platform(model.platform);
            this.progress(model.progress);
            this.snapshotDetails(model.snapshotDetails);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final Collection<SnapshotDetail.Builder> getSnapshotDetails() {
            return this.snapshotDetails != null ? (Collection)this.snapshotDetails.stream().map(SnapshotDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshotDetails(Collection<SnapshotDetail> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copy(snapshotDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(SnapshotDetail ... snapshotDetails) {
            this.snapshotDetails(Arrays.asList(snapshotDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotDetails(Consumer<SnapshotDetail.Builder> ... snapshotDetails) {
            this.snapshotDetails(Stream.of(snapshotDetails).map(c -> (SnapshotDetail)((SnapshotDetail.Builder)SnapshotDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshotDetails(Collection<SnapshotDetail.BuilderImpl> snapshotDetails) {
            this.snapshotDetails = SnapshotDetailListCopier.copyFromBuilder(snapshotDetails);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ImportImageTask build() {
            return new ImportImageTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportImageTask> {
        public Builder architecture(String var1);

        public Builder description(String var1);

        public Builder hypervisor(String var1);

        public Builder imageId(String var1);

        public Builder importTaskId(String var1);

        public Builder licenseType(String var1);

        public Builder platform(String var1);

        public Builder progress(String var1);

        public Builder snapshotDetails(Collection<SnapshotDetail> var1);

        public Builder snapshotDetails(SnapshotDetail ... var1);

        public Builder snapshotDetails(Consumer<SnapshotDetail.Builder> ... var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);
    }
}

