/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;
import software.amazon.awssdk.services.ec2.model.KeyPairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeyPairsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeKeyPairsResponse> {
    private final List<KeyPairInfo> keyPairs;

    private DescribeKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
    }

    public List<KeyPairInfo> keyPairs() {
        return this.keyPairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsResponse)) {
            return false;
        }
        DescribeKeyPairsResponse other = (DescribeKeyPairsResponse)((Object)obj);
        return Objects.equals(this.keyPairs(), other.keyPairs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeKeyPairsResponse").add("KeyPairs", this.keyPairs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPairs": {
                return Optional.ofNullable(clazz.cast(this.keyPairs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<KeyPairInfo> keyPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsResponse model) {
            super(model);
            this.keyPairs(model.keyPairs);
        }

        public final Collection<KeyPairInfo.Builder> getKeyPairs() {
            return this.keyPairs != null ? (Collection)this.keyPairs.stream().map(KeyPairInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPairInfo> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPairInfo ... keyPairs) {
            this.keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(Consumer<KeyPairInfo.Builder> ... keyPairs) {
            this.keyPairs(Stream.of(keyPairs).map(c -> (KeyPairInfo)((KeyPairInfo.Builder)KeyPairInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPairInfo.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        @Override
        public DescribeKeyPairsResponse build() {
            return new DescribeKeyPairsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeKeyPairsResponse> {
        public Builder keyPairs(Collection<KeyPairInfo> var1);

        public Builder keyPairs(KeyPairInfo ... var1);

        public Builder keyPairs(Consumer<KeyPairInfo.Builder> ... var1);
    }
}

