/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FpgaImageAttributeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFpgaImageAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeFpgaImageAttributeRequest> {
    private final String fpgaImageId;
    private final String attribute;

    private DescribeFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
    }

    public String fpgaImageId() {
        return this.fpgaImageId;
    }

    public FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImageAttributeRequest)) {
            return false;
        }
        DescribeFpgaImageAttributeRequest other = (DescribeFpgaImageAttributeRequest)((Object)obj);
        return Objects.equals(this.fpgaImageId(), other.fpgaImageId()) && Objects.equals(this.attributeAsString(), other.attributeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFpgaImageAttributeRequest").add("FpgaImageId", (Object)this.fpgaImageId()).add("Attribute", (Object)this.attributeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImageId": {
                return Optional.ofNullable(clazz.cast(this.fpgaImageId()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String fpgaImageId;
        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImageAttributeRequest model) {
            super(model);
            this.fpgaImageId(model.fpgaImageId);
            this.attribute(model.attribute);
        }

        public final String getFpgaImageId() {
            return this.fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFpgaImageAttributeRequest build() {
            return new DescribeFpgaImageAttributeRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeFpgaImageAttributeRequest> {
        public Builder fpgaImageId(String var1);

        public Builder attribute(String var1);

        public Builder attribute(FpgaImageAttributeName var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

