/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSecurityGroupRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateSecurityGroupRequest> {
    private final String description;
    private final String groupName;
    private final String vpcId;

    private CreateSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.groupName = builder.groupName;
        this.vpcId = builder.vpcId;
    }

    public String description() {
        return this.description;
    }

    public String groupName() {
        return this.groupName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityGroupRequest)) {
            return false;
        }
        CreateSecurityGroupRequest other = (CreateSecurityGroupRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"CreateSecurityGroupRequest").add("Description", (Object)this.description()).add("GroupName", (Object)this.groupName()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String description;
        private String groupName;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityGroupRequest model) {
            super(model);
            this.description(model.description);
            this.groupName(model.groupName);
            this.vpcId(model.vpcId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityGroupRequest build() {
            return new CreateSecurityGroupRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, CreateSecurityGroupRequest> {
        public Builder description(String var1);

        public Builder groupName(String var1);

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

