/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelledSpotInstanceRequest
implements ToCopyableBuilder<Builder, CancelledSpotInstanceRequest> {
    private final String spotInstanceRequestId;
    private final String state;

    private CancelledSpotInstanceRequest(BuilderImpl builder) {
        this.spotInstanceRequestId = builder.spotInstanceRequestId;
        this.state = builder.state;
    }

    public String spotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public CancelSpotInstanceRequestState state() {
        return CancelSpotInstanceRequestState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelledSpotInstanceRequest)) {
            return false;
        }
        CancelledSpotInstanceRequest other = (CancelledSpotInstanceRequest)obj;
        return Objects.equals(this.spotInstanceRequestId(), other.spotInstanceRequestId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public String toString() {
        return ToString.builder((String)"CancelledSpotInstanceRequest").add("SpotInstanceRequestId", (Object)this.spotInstanceRequestId()).add("State", (Object)this.stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotInstanceRequestId": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequestId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String spotInstanceRequestId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelledSpotInstanceRequest model) {
            this.spotInstanceRequestId(model.spotInstanceRequestId);
            this.state(model.state);
        }

        public final String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        @Override
        public final Builder spotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        public final void setSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CancelSpotInstanceRequestState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public CancelledSpotInstanceRequest build() {
            return new CancelledSpotInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelledSpotInstanceRequest> {
        public Builder spotInstanceRequestId(String var1);

        public Builder state(String var1);

        public Builder state(CancelSpotInstanceRequestState var1);
    }
}

