/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllocateHostsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AllocateHostsResponse> {
    private final List<String> hostIds;

    private AllocateHostsResponse(BuilderImpl builder) {
        super(builder);
        this.hostIds = builder.hostIds;
    }

    public List<String> hostIds() {
        return this.hostIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsResponse)) {
            return false;
        }
        AllocateHostsResponse other = (AllocateHostsResponse)((Object)obj);
        return Objects.equals(this.hostIds(), other.hostIds());
    }

    public String toString() {
        return ToString.builder((String)"AllocateHostsResponse").add("HostIds", this.hostIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostIds": {
                return Optional.ofNullable(clazz.cast(this.hostIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<String> hostIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsResponse model) {
            super(model);
            this.hostIds(model.hostIds);
        }

        public final Collection<String> getHostIds() {
            return this.hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = ResponseHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String ... hostIds) {
            this.hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = ResponseHostIdListCopier.copy(hostIds);
        }

        @Override
        public AllocateHostsResponse build() {
            return new AllocateHostsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, AllocateHostsResponse> {
        public Builder hostIds(Collection<String> var1);

        public Builder hostIds(String ... var1);
    }
}

