/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ImageAttribute;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchPermissionUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ProductCodeUnmarshaller;

public class ImageAttributeUnmarshaller
implements Unmarshaller<ImageAttribute, StaxUnmarshallerContext> {
    private static final ImageAttributeUnmarshaller INSTANCE = new ImageAttributeUnmarshaller();

    public ImageAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        ImageAttribute.Builder imageAttribute;
        block14: {
            imageAttribute = ImageAttribute.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<BlockDeviceMapping> blockDeviceMappings = null;
            ArrayList<LaunchPermission> launchPermissions = null;
            ArrayList<ProductCode> productCodes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    imageAttribute.blockDeviceMappings(blockDeviceMappings);
                    imageAttribute.launchPermissions(launchPermissions);
                    imageAttribute.productCodes(productCodes);
                    break block14;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("blockDeviceMapping", targetDepth)) {
                        blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                        blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageId", targetDepth)) {
                        imageAttribute.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("launchPermission", targetDepth)) {
                        launchPermissions = new ArrayList<LaunchPermission>();
                        continue;
                    }
                    if (context.testExpression("launchPermission/item", targetDepth)) {
                        launchPermissions.add(LaunchPermissionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("productCodes", targetDepth)) {
                        productCodes = new ArrayList<ProductCode>();
                        continue;
                    }
                    if (context.testExpression("productCodes/item", targetDepth)) {
                        productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("description/value", targetDepth)) {
                        imageAttribute.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("kernel/value", targetDepth)) {
                        imageAttribute.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ramdisk/value", targetDepth)) {
                        imageAttribute.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("sriovNetSupport/value", targetDepth)) continue;
                    imageAttribute.sriovNetSupport(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            imageAttribute.blockDeviceMappings(blockDeviceMappings);
            imageAttribute.launchPermissions(launchPermissions);
            imageAttribute.productCodes(productCodes);
        }
        return (ImageAttribute)imageAttribute.build();
    }

    public static ImageAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

