/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestHistoryRequest;

public class DescribeSpotFleetRequestHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetRequestHistoryRequest>, DescribeSpotFleetRequestHistoryRequest> {
    public Request<DescribeSpotFleetRequestHistoryRequest> marshall(DescribeSpotFleetRequestHistoryRequest describeSpotFleetRequestHistoryRequest) {
        if (describeSpotFleetRequestHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeSpotFleetRequestHistoryRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotFleetRequestHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSpotFleetRequestHistoryRequest.eventTypeAsString() != null) {
            request.addParameter("EventType", StringUtils.fromString((String)describeSpotFleetRequestHistoryRequest.eventTypeAsString()));
        }
        if (describeSpotFleetRequestHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotFleetRequestHistoryRequest.maxResults()));
        }
        if (describeSpotFleetRequestHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotFleetRequestHistoryRequest.nextToken()));
        }
        if (describeSpotFleetRequestHistoryRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringUtils.fromString((String)describeSpotFleetRequestHistoryRequest.spotFleetRequestId()));
        }
        if (describeSpotFleetRequestHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)describeSpotFleetRequestHistoryRequest.startTime()));
        }
        return request;
    }
}

