/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DeleteKeyPairRequest;

public class DeleteKeyPairRequestMarshaller
implements Marshaller<Request<DeleteKeyPairRequest>, DeleteKeyPairRequest> {
    public Request<DeleteKeyPairRequest> marshall(DeleteKeyPairRequest deleteKeyPairRequest) {
        if (deleteKeyPairRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteKeyPairRequest, "EC2Client");
        request.addParameter("Action", "DeleteKeyPair");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteKeyPairRequest.keyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)deleteKeyPairRequest.keyName()));
        }
        return request;
    }
}

