/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.VolumeAttachmentState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeAttachment
implements ToCopyableBuilder<Builder, VolumeAttachment> {
    private final Instant attachTime;
    private final String device;
    private final String instanceId;
    private final String state;
    private final String volumeId;
    private final Boolean deleteOnTermination;

    private VolumeAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.device = builder.device;
        this.instanceId = builder.instanceId;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    public Instant attachTime() {
        return this.attachTime;
    }

    public String device() {
        return this.device;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public VolumeAttachmentState state() {
        return VolumeAttachmentState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeAttachment)) {
            return false;
        }
        VolumeAttachment other = (VolumeAttachment)obj;
        return Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.device(), other.device()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination());
    }

    public String toString() {
        return ToString.builder((String)"VolumeAttachment").add("AttachTime", (Object)this.attachTime()).add("Device", (Object)this.device()).add("InstanceId", (Object)this.instanceId()).add("State", (Object)this.stateAsString()).add("VolumeId", (Object)this.volumeId()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachTime": {
                return Optional.of(clazz.cast(this.attachTime()));
            }
            case "Device": {
                return Optional.of(clazz.cast(this.device()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
            case "DeleteOnTermination": {
                return Optional.of(clazz.cast(this.deleteOnTermination()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private String device;
        private String instanceId;
        private String state;
        private String volumeId;
        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeAttachment model) {
            this.attachTime(model.attachTime);
            this.device(model.device);
            this.instanceId(model.instanceId);
            this.state(model.state);
            this.volumeId(model.volumeId);
            this.deleteOnTermination(model.deleteOnTermination);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeAttachmentState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public VolumeAttachment build() {
            return new VolumeAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeAttachment> {
        public Builder attachTime(Instant var1);

        public Builder device(String var1);

        public Builder instanceId(String var1);

        public Builder state(String var1);

        public Builder state(VolumeAttachmentState var1);

        public Builder volumeId(String var1);

        public Builder deleteOnTermination(Boolean var1);
    }
}

