/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.InstanceStateChangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TerminateInstancesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, TerminateInstancesResponse> {
    private final List<InstanceStateChange> terminatingInstances;

    private TerminateInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.terminatingInstances = builder.terminatingInstances;
    }

    public List<InstanceStateChange> terminatingInstances() {
        return this.terminatingInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.terminatingInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstancesResponse)) {
            return false;
        }
        TerminateInstancesResponse other = (TerminateInstancesResponse)((Object)obj);
        return Objects.equals(this.terminatingInstances(), other.terminatingInstances());
    }

    public String toString() {
        return ToString.builder((String)"TerminateInstancesResponse").add("TerminatingInstances", this.terminatingInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminatingInstances": {
                return Optional.of(clazz.cast(this.terminatingInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<InstanceStateChange> terminatingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstancesResponse model) {
            super(model);
            this.terminatingInstances(model.terminatingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getTerminatingInstances() {
            return this.terminatingInstances != null ? (Collection)this.terminatingInstances.stream().map(InstanceStateChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder terminatingInstances(Collection<InstanceStateChange> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copy(terminatingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminatingInstances(InstanceStateChange ... terminatingInstances) {
            this.terminatingInstances(Arrays.asList(terminatingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminatingInstances(Consumer<InstanceStateChange.Builder> ... terminatingInstances) {
            this.terminatingInstances(Stream.of(terminatingInstances).map(c -> (InstanceStateChange)((InstanceStateChange.Builder)InstanceStateChange.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTerminatingInstances(Collection<InstanceStateChange.BuilderImpl> terminatingInstances) {
            this.terminatingInstances = InstanceStateChangeListCopier.copyFromBuilder(terminatingInstances);
        }

        @Override
        public TerminateInstancesResponse build() {
            return new TerminateInstancesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, TerminateInstancesResponse> {
        public Builder terminatingInstances(Collection<InstanceStateChange> var1);

        public Builder terminatingInstances(InstanceStateChange ... var1);

        public Builder terminatingInstances(Consumer<InstanceStateChange.Builder> ... var1);
    }
}

