/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PriceSchedule
implements ToCopyableBuilder<Builder, PriceSchedule> {
    private final Boolean active;
    private final String currencyCode;
    private final Double price;
    private final Long term;

    private PriceSchedule(BuilderImpl builder) {
        this.active = builder.active;
        this.currencyCode = builder.currencyCode;
        this.price = builder.price;
        this.term = builder.term;
    }

    public Boolean active() {
        return this.active;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeAsString() {
        return this.currencyCode;
    }

    public Double price() {
        return this.price;
    }

    public Long term() {
        return this.term;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.term());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceSchedule)) {
            return false;
        }
        PriceSchedule other = (PriceSchedule)obj;
        return Objects.equals(this.active(), other.active()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.price(), other.price()) && Objects.equals(this.term(), other.term());
    }

    public String toString() {
        return ToString.builder((String)"PriceSchedule").add("Active", (Object)this.active()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Price", (Object)this.price()).add("Term", (Object)this.term()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Active": {
                return Optional.of(clazz.cast(this.active()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeAsString()));
            }
            case "Price": {
                return Optional.of(clazz.cast(this.price()));
            }
            case "Term": {
                return Optional.of(clazz.cast(this.term()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean active;
        private String currencyCode;
        private Double price;
        private Long term;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceSchedule model) {
            this.active(model.active);
            this.currencyCode(model.currencyCode);
            this.price(model.price);
            this.term(model.term);
        }

        public final Boolean getActive() {
            return this.active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Double getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public final Long getTerm() {
            return this.term;
        }

        @Override
        public final Builder term(Long term) {
            this.term = term;
            return this;
        }

        public final void setTerm(Long term) {
            this.term = term;
        }

        public PriceSchedule build() {
            return new PriceSchedule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PriceSchedule> {
        public Builder active(Boolean var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder price(Double var1);

        public Builder term(Long var1);
    }
}

