/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceAttribute
implements ToCopyableBuilder<Builder, InstanceAttribute> {
    private final List<GroupIdentifier> groups;
    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private final Boolean disableApiTermination;
    private final Boolean enaSupport;
    private final Boolean ebsOptimized;
    private final String instanceId;
    private final String instanceInitiatedShutdownBehavior;
    private final String instanceType;
    private final String kernelId;
    private final List<ProductCode> productCodes;
    private final String ramdiskId;
    private final String rootDeviceName;
    private final Boolean sourceDestCheck;
    private final String sriovNetSupport;
    private final String userData;

    private InstanceAttribute(BuilderImpl builder) {
        this.groups = builder.groups;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.enaSupport = builder.enaSupport;
        this.ebsOptimized = builder.ebsOptimized;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
    }

    public List<GroupIdentifier> groups() {
        return this.groups;
    }

    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String rootDeviceName() {
        return this.rootDeviceName;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public String userData() {
        return this.userData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAttribute)) {
            return false;
        }
        InstanceAttribute other = (InstanceAttribute)obj;
        return Objects.equals(this.groups(), other.groups()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.ramdiskId(), other.ramdiskId()) && Objects.equals(this.rootDeviceName(), other.rootDeviceName()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.userData(), other.userData());
    }

    public String toString() {
        return ToString.builder((String)"InstanceAttribute").add("Groups", this.groups()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("EnaSupport", (Object)this.enaSupport()).add("EbsOptimized", (Object)this.ebsOptimized()).add("InstanceId", (Object)this.instanceId()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehavior()).add("InstanceType", (Object)this.instanceType()).add("KernelId", (Object)this.kernelId()).add("ProductCodes", this.productCodes()).add("RamdiskId", (Object)this.ramdiskId()).add("RootDeviceName", (Object)this.rootDeviceName()).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("UserData", (Object)this.userData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Groups": {
                return Optional.of(clazz.cast(this.groups()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "DisableApiTermination": {
                return Optional.of(clazz.cast(this.disableApiTermination()));
            }
            case "EnaSupport": {
                return Optional.of(clazz.cast(this.enaSupport()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.of(clazz.cast(this.instanceInitiatedShutdownBehavior()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "KernelId": {
                return Optional.of(clazz.cast(this.kernelId()));
            }
            case "ProductCodes": {
                return Optional.of(clazz.cast(this.productCodes()));
            }
            case "RamdiskId": {
                return Optional.of(clazz.cast(this.ramdiskId()));
            }
            case "RootDeviceName": {
                return Optional.of(clazz.cast(this.rootDeviceName()));
            }
            case "SourceDestCheck": {
                return Optional.of(clazz.cast(this.sourceDestCheck()));
            }
            case "SriovNetSupport": {
                return Optional.of(clazz.cast(this.sriovNetSupport()));
            }
            case "UserData": {
                return Optional.of(clazz.cast(this.userData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<GroupIdentifier> groups;
        private List<InstanceBlockDeviceMapping> blockDeviceMappings;
        private Boolean disableApiTermination;
        private Boolean enaSupport;
        private Boolean ebsOptimized;
        private String instanceId;
        private String instanceInitiatedShutdownBehavior;
        private String instanceType;
        private String kernelId;
        private List<ProductCode> productCodes;
        private String ramdiskId;
        private String rootDeviceName;
        private Boolean sourceDestCheck;
        private String sriovNetSupport;
        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAttribute model) {
            this.groups(model.groups);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.disableApiTermination(model.disableApiTermination);
            this.enaSupport(model.enaSupport);
            this.ebsOptimized(model.ebsOptimized);
            this.instanceId(model.instanceId);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.instanceType(model.instanceType);
            this.kernelId(model.kernelId);
            this.productCodes(model.productCodes);
            this.ramdiskId(model.ramdiskId);
            this.rootDeviceName(model.rootDeviceName);
            this.sourceDestCheck(model.sourceDestCheck);
            this.sriovNetSupport(model.sriovNetSupport);
            this.userData(model.userData);
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(InstanceBlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (InstanceBlockDeviceMapping)((InstanceBlockDeviceMapping.Builder)InstanceBlockDeviceMapping.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getRootDeviceName() {
            return this.rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public InstanceAttribute build() {
            return new InstanceAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceAttribute> {
        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder> ... var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder enaSupport(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder instanceId(String var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceType(String var1);

        public Builder kernelId(String var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder ramdiskId(String var1);

        public Builder rootDeviceName(String var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder sriovNetSupport(String var1);

        public Builder userData(String var1);
    }
}

