/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.PaymentOption;
import software.amazon.awssdk.services.ec2.model.ReservationState;
import software.amazon.awssdk.services.ec2.model.ResponseHostIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostReservation
implements ToCopyableBuilder<Builder, HostReservation> {
    private final Integer count;
    private final String currencyCode;
    private final Integer duration;
    private final Instant end;
    private final List<String> hostIdSet;
    private final String hostReservationId;
    private final String hourlyPrice;
    private final String instanceFamily;
    private final String offeringId;
    private final String paymentOption;
    private final Instant start;
    private final String state;
    private final String upfrontPrice;

    private HostReservation(BuilderImpl builder) {
        this.count = builder.count;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.end = builder.end;
        this.hostIdSet = builder.hostIdSet;
        this.hostReservationId = builder.hostReservationId;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.start = builder.start;
        this.state = builder.state;
        this.upfrontPrice = builder.upfrontPrice;
    }

    public Integer count() {
        return this.count;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeAsString() {
        return this.currencyCode;
    }

    public Integer duration() {
        return this.duration;
    }

    public Instant end() {
        return this.end;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String hostReservationId() {
        return this.hostReservationId;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String instanceFamily() {
        return this.instanceFamily;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public String paymentOptionAsString() {
        return this.paymentOption;
    }

    public Instant start() {
        return this.start;
    }

    public ReservationState state() {
        return ReservationState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String upfrontPrice() {
        return this.upfrontPrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontPrice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostReservation)) {
            return false;
        }
        HostReservation other = (HostReservation)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.hostIdSet(), other.hostIdSet()) && Objects.equals(this.hostReservationId(), other.hostReservationId()) && Objects.equals(this.hourlyPrice(), other.hourlyPrice()) && Objects.equals(this.instanceFamily(), other.instanceFamily()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.upfrontPrice(), other.upfrontPrice());
    }

    public String toString() {
        return ToString.builder((String)"HostReservation").add("Count", (Object)this.count()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Duration", (Object)this.duration()).add("End", (Object)this.end()).add("HostIdSet", this.hostIdSet()).add("HostReservationId", (Object)this.hostReservationId()).add("HourlyPrice", (Object)this.hourlyPrice()).add("InstanceFamily", (Object)this.instanceFamily()).add("OfferingId", (Object)this.offeringId()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("Start", (Object)this.start()).add("State", (Object)this.stateAsString()).add("UpfrontPrice", (Object)this.upfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeAsString()));
            }
            case "Duration": {
                return Optional.of(clazz.cast(this.duration()));
            }
            case "End": {
                return Optional.of(clazz.cast(this.end()));
            }
            case "HostIdSet": {
                return Optional.of(clazz.cast(this.hostIdSet()));
            }
            case "HostReservationId": {
                return Optional.of(clazz.cast(this.hostReservationId()));
            }
            case "HourlyPrice": {
                return Optional.of(clazz.cast(this.hourlyPrice()));
            }
            case "InstanceFamily": {
                return Optional.of(clazz.cast(this.instanceFamily()));
            }
            case "OfferingId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
            case "PaymentOption": {
                return Optional.of(clazz.cast(this.paymentOptionAsString()));
            }
            case "Start": {
                return Optional.of(clazz.cast(this.start()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "UpfrontPrice": {
                return Optional.of(clazz.cast(this.upfrontPrice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private String currencyCode;
        private Integer duration;
        private Instant end;
        private List<String> hostIdSet;
        private String hostReservationId;
        private String hourlyPrice;
        private String instanceFamily;
        private String offeringId;
        private String paymentOption;
        private Instant start;
        private String state;
        private String upfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HostReservation model) {
            this.count(model.count);
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.end(model.end);
            this.hostIdSet(model.hostIdSet);
            this.hostReservationId(model.hostReservationId);
            this.hourlyPrice(model.hourlyPrice);
            this.instanceFamily(model.instanceFamily);
            this.offeringId(model.offeringId);
            this.paymentOption(model.paymentOption);
            this.start(model.start);
            this.state(model.state);
            this.upfrontPrice(model.upfrontPrice);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Instant getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = ResponseHostIdSetCopier.copy(hostIdSet);
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Instant getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getUpfrontPrice() {
            return this.upfrontPrice;
        }

        @Override
        public final Builder upfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
            return this;
        }

        public final void setUpfrontPrice(String upfrontPrice) {
            this.upfrontPrice = upfrontPrice;
        }

        public HostReservation build() {
            return new HostReservation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostReservation> {
        public Builder count(Integer var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder duration(Integer var1);

        public Builder end(Instant var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder hostReservationId(String var1);

        public Builder hourlyPrice(String var1);

        public Builder instanceFamily(String var1);

        public Builder offeringId(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder start(Instant var1);

        public Builder state(String var1);

        public Builder state(ReservationState var1);

        public Builder upfrontPrice(String var1);
    }
}

