/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.VpnConnection;
import software.amazon.awssdk.services.ec2.model.VpnConnectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpnConnectionsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
    private final List<VpnConnection> vpnConnections;

    private DescribeVpnConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpnConnections = builder.vpnConnections;
    }

    public List<VpnConnection> vpnConnections() {
        return this.vpnConnections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsResponse)) {
            return false;
        }
        DescribeVpnConnectionsResponse other = (DescribeVpnConnectionsResponse)((Object)obj);
        return Objects.equals(this.vpnConnections(), other.vpnConnections());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpnConnectionsResponse").add("VpnConnections", this.vpnConnections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnections": {
                return Optional.of(clazz.cast(this.vpnConnections()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<VpnConnection> vpnConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsResponse model) {
            super(model);
            this.vpnConnections(model.vpnConnections);
        }

        public final Collection<VpnConnection.Builder> getVpnConnections() {
            return this.vpnConnections != null ? (Collection)this.vpnConnections.stream().map(VpnConnection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpnConnections(Collection<VpnConnection> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copy(vpnConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnections(VpnConnection ... vpnConnections) {
            this.vpnConnections(Arrays.asList(vpnConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnections(Consumer<VpnConnection.Builder> ... vpnConnections) {
            this.vpnConnections(Stream.of(vpnConnections).map(c -> (VpnConnection)((VpnConnection.Builder)VpnConnection.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpnConnections(Collection<VpnConnection.BuilderImpl> vpnConnections) {
            this.vpnConnections = VpnConnectionListCopier.copyFromBuilder(vpnConnections);
        }

        @Override
        public DescribeVpnConnectionsResponse build() {
            return new DescribeVpnConnectionsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeVpnConnectionsResponse> {
        public Builder vpnConnections(Collection<VpnConnection> var1);

        public Builder vpnConnections(VpnConnection ... var1);

        public Builder vpnConnections(Consumer<VpnConnection.Builder> ... var1);
    }
}

