/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteVpnConnectionRouteRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DeleteVpnConnectionRouteRequest> {
    private final String destinationCidrBlock;
    private final String vpnConnectionId;

    private DeleteVpnConnectionRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.vpnConnectionId = builder.vpnConnectionId;
    }

    public String destinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpnConnectionRouteRequest)) {
            return false;
        }
        DeleteVpnConnectionRouteRequest other = (DeleteVpnConnectionRouteRequest)((Object)obj);
        return Objects.equals(this.destinationCidrBlock(), other.destinationCidrBlock()) && Objects.equals(this.vpnConnectionId(), other.vpnConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteVpnConnectionRouteRequest").add("DestinationCidrBlock", (Object)this.destinationCidrBlock()).add("VpnConnectionId", (Object)this.vpnConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationCidrBlock": {
                return Optional.of(clazz.cast(this.destinationCidrBlock()));
            }
            case "VpnConnectionId": {
                return Optional.of(clazz.cast(this.vpnConnectionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String destinationCidrBlock;
        private String vpnConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpnConnectionRouteRequest model) {
            super(model);
            this.destinationCidrBlock(model.destinationCidrBlock);
            this.vpnConnectionId(model.vpnConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpnConnectionRouteRequest build() {
            return new DeleteVpnConnectionRouteRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DeleteVpnConnectionRouteRequest> {
        public Builder destinationCidrBlock(String var1);

        public Builder vpnConnectionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

