/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecification;
import software.amazon.awssdk.services.ec2.model.PriceScheduleSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateReservedInstancesListingRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
    private final String clientToken;
    private final Integer instanceCount;
    private final List<PriceScheduleSpecification> priceSchedules;
    private final String reservedInstancesId;

    private CreateReservedInstancesListingRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public List<PriceScheduleSpecification> priceSchedules() {
        return this.priceSchedules;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.priceSchedules(), other.priceSchedules()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId());
    }

    public String toString() {
        return ToString.builder((String)"CreateReservedInstancesListingRequest").add("ClientToken", (Object)this.clientToken()).add("InstanceCount", (Object)this.instanceCount()).add("PriceSchedules", this.priceSchedules()).add("ReservedInstancesId", (Object)this.reservedInstancesId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "PriceSchedules": {
                return Optional.of(clazz.cast(this.priceSchedules()));
            }
            case "ReservedInstancesId": {
                return Optional.of(clazz.cast(this.reservedInstancesId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private Integer instanceCount;
        private List<PriceScheduleSpecification> priceSchedules;
        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.instanceCount(model.instanceCount);
            this.priceSchedules(model.priceSchedules);
            this.reservedInstancesId(model.reservedInstancesId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Collection<PriceScheduleSpecification.Builder> getPriceSchedules() {
            return this.priceSchedules != null ? (Collection)this.priceSchedules.stream().map(PriceScheduleSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceScheduleSpecification ... priceSchedules) {
            this.priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder> ... priceSchedules) {
            this.priceSchedules(Stream.of(priceSchedules).map(c -> (PriceScheduleSpecification)((PriceScheduleSpecification.Builder)PriceScheduleSpecification.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceScheduleSpecification.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleSpecificationListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateReservedInstancesListingRequest build() {
            return new CreateReservedInstancesListingRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateReservedInstancesListingRequest> {
        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder priceSchedules(Collection<PriceScheduleSpecification> var1);

        public Builder priceSchedules(PriceScheduleSpecification ... var1);

        public Builder priceSchedules(Consumer<PriceScheduleSpecification.Builder> ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

