/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.VgwTelemetry;
import software.amazon.awssdk.services.ec2.model.VpnConnection;
import software.amazon.awssdk.services.ec2.model.VpnStaticRoute;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VgwTelemetryUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpnConnectionOptionsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpnStaticRouteUnmarshaller;

public class VpnConnectionUnmarshaller
implements Unmarshaller<VpnConnection, StaxUnmarshallerContext> {
    private static VpnConnectionUnmarshaller INSTANCE;

    public VpnConnection unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        VpnConnection.Builder vpnConnection = VpnConnection.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("customerGatewayConfiguration", targetDepth)) {
                    vpnConnection.customerGatewayConfiguration(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("customerGatewayId", targetDepth)) {
                    vpnConnection.customerGatewayId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    vpnConnection.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("type", targetDepth)) {
                    vpnConnection.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpnConnectionId", targetDepth)) {
                    vpnConnection.vpnConnectionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpnGatewayId", targetDepth)) {
                    vpnConnection.vpnGatewayId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("options", targetDepth)) {
                    vpnConnection.options(VpnConnectionOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routes", targetDepth)) {
                    vpnConnection.routes(new ArrayList<VpnStaticRoute>());
                    continue;
                }
                if (context.testExpression("routes/item", targetDepth)) {
                    vpnConnection.routes(VpnStaticRouteUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    vpnConnection.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    vpnConnection.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vgwTelemetry", targetDepth)) {
                    vpnConnection.vgwTelemetry(new ArrayList<VgwTelemetry>());
                    continue;
                }
                if (!context.testExpression("vgwTelemetry/item", targetDepth)) continue;
                vpnConnection.vgwTelemetry(VgwTelemetryUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (VpnConnection)vpnConnection.build();
    }

    public static VpnConnectionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VpnConnectionUnmarshaller();
        }
        return INSTANCE;
    }
}

