/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VpcIpv6CidrBlockAssociationUnmarshaller;

public class VpcUnmarshaller
implements Unmarshaller<Vpc, StaxUnmarshallerContext> {
    private static VpcUnmarshaller INSTANCE;

    public Vpc unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Vpc.Builder vpc = Vpc.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("cidrBlock", targetDepth)) {
                    vpc.cidrBlock(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("dhcpOptionsId", targetDepth)) {
                    vpc.dhcpOptionsId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    vpc.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    vpc.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceTenancy", targetDepth)) {
                    vpc.instanceTenancy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6CidrBlockAssociationSet", targetDepth)) {
                    vpc.ipv6CidrBlockAssociationSet(new ArrayList<VpcIpv6CidrBlockAssociation>());
                    continue;
                }
                if (context.testExpression("ipv6CidrBlockAssociationSet/item", targetDepth)) {
                    vpc.ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("isDefault", targetDepth)) {
                    vpc.isDefault(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    vpc.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                vpc.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Vpc)vpc.build();
    }

    public static VpcUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VpcUnmarshaller();
        }
        return INSTANCE;
    }
}

