/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.Volume;
import software.amazon.awssdk.services.ec2.model.VolumeAttachment;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.VolumeAttachmentUnmarshaller;

public class VolumeUnmarshaller
implements Unmarshaller<Volume, StaxUnmarshallerContext> {
    private static VolumeUnmarshaller INSTANCE;

    public Volume unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Volume.Builder volume = Volume.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("attachmentSet", targetDepth)) {
                    volume.attachments(new ArrayList<VolumeAttachment>());
                    continue;
                }
                if (context.testExpression("attachmentSet/item", targetDepth)) {
                    volume.attachments(VolumeAttachmentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    volume.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createTime", targetDepth)) {
                    volume.createTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("encrypted", targetDepth)) {
                    volume.encrypted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("kmsKeyId", targetDepth)) {
                    volume.kmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("size", targetDepth)) {
                    volume.size(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("snapshotId", targetDepth)) {
                    volume.snapshotId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("status", targetDepth)) {
                    volume.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("volumeId", targetDepth)) {
                    volume.volumeId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("iops", targetDepth)) {
                    volume.iops(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    volume.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    volume.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("volumeType", targetDepth)) continue;
                volume.volumeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Volume)volume.build();
    }

    public static VolumeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new VolumeUnmarshaller();
        }
        return INSTANCE;
    }
}

