/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.Date;
import java.util.Iterator;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.util.StringUtils;

public class RequestSpotInstancesRequestMarshaller
implements Marshaller<Request<RequestSpotInstancesRequest>, RequestSpotInstancesRequest> {
    public Request<RequestSpotInstancesRequest> marshall(RequestSpotInstancesRequest requestSpotInstancesRequest) {
        LaunchSpecification launchSpecification;
        if (requestSpotInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotInstancesRequest, "EC2Client");
        request.addParameter("Action", "RequestSpotInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (requestSpotInstancesRequest.availabilityZoneGroup() != null) {
            request.addParameter("AvailabilityZoneGroup", StringUtils.fromString((String)requestSpotInstancesRequest.availabilityZoneGroup()));
        }
        if (requestSpotInstancesRequest.blockDurationMinutes() != null) {
            request.addParameter("BlockDurationMinutes", StringUtils.fromInteger((Integer)requestSpotInstancesRequest.blockDurationMinutes()));
        }
        if (requestSpotInstancesRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)requestSpotInstancesRequest.clientToken()));
        }
        if (requestSpotInstancesRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)requestSpotInstancesRequest.instanceCount()));
        }
        if (requestSpotInstancesRequest.launchGroup() != null) {
            request.addParameter("LaunchGroup", StringUtils.fromString((String)requestSpotInstancesRequest.launchGroup()));
        }
        if ((launchSpecification = requestSpotInstancesRequest.launchSpecification()) != null) {
            SdkInternalList launchSpecificationSecurityGroupsList;
            SdkInternalList launchSpecificationAllSecurityGroupsList;
            SpotPlacement placement;
            SdkInternalList launchSpecificationNetworkInterfacesList;
            IamInstanceProfileSpecification iamInstanceProfile;
            SdkInternalList launchSpecificationBlockDeviceMappingsList;
            if (launchSpecification.userData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString((String)launchSpecification.userData()));
            }
            if (launchSpecification.addressingType() != null) {
                request.addParameter("LaunchSpecification.AddressingType", StringUtils.fromString((String)launchSpecification.addressingType()));
            }
            if (!(launchSpecificationBlockDeviceMappingsList = (SdkInternalList)launchSpecification.blockDeviceMappings()).isEmpty() || !launchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (BlockDeviceMapping launchSpecificationBlockDeviceMappingsListValue : launchSpecificationBlockDeviceMappingsList) {
                    Object ebs;
                    if (launchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)launchSpecificationBlockDeviceMappingsListValue.deviceName()));
                    }
                    if (launchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)launchSpecificationBlockDeviceMappingsListValue.virtualName()));
                    }
                    if ((ebs = launchSpecificationBlockDeviceMappingsListValue.ebs()) != null) {
                        if (((EbsBlockDevice)ebs).encrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)((EbsBlockDevice)ebs).encrypted()));
                        }
                        if (((EbsBlockDevice)ebs).deleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)((EbsBlockDevice)ebs).deleteOnTermination()));
                        }
                        if (((EbsBlockDevice)ebs).iops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)((EbsBlockDevice)ebs).iops()));
                        }
                        if (((EbsBlockDevice)ebs).snapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)((EbsBlockDevice)ebs).snapshotId()));
                        }
                        if (((EbsBlockDevice)ebs).volumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)((EbsBlockDevice)ebs).volumeSize()));
                        }
                        if (((EbsBlockDevice)ebs).volumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)((EbsBlockDevice)ebs).volumeType()));
                        }
                    }
                    if (launchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)launchSpecificationBlockDeviceMappingsListValue.noDevice()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (launchSpecification.ebsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean((Boolean)launchSpecification.ebsOptimized()));
            }
            if ((iamInstanceProfile = launchSpecification.iamInstanceProfile()) != null) {
                if (iamInstanceProfile.arn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.arn()));
                }
                if (iamInstanceProfile.name() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.name()));
                }
            }
            if (launchSpecification.imageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString((String)launchSpecification.imageId()));
            }
            if (launchSpecification.instanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.instanceType()));
            }
            if (launchSpecification.kernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString((String)launchSpecification.kernelId()));
            }
            if (launchSpecification.keyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString((String)launchSpecification.keyName()));
            }
            if (!(launchSpecificationNetworkInterfacesList = (SdkInternalList)launchSpecification.networkInterfaces()).isEmpty() || !launchSpecificationNetworkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (InstanceNetworkInterfaceSpecification launchSpecificationNetworkInterfacesListValue : launchSpecificationNetworkInterfacesList) {
                    SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                    SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                    Iterator instanceNetworkInterfaceSpecificationGroupsList;
                    if (launchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.associatePublicIpAddress()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.deleteOnTermination()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.description() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.description()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.deviceIndex()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.groups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                        int groupsListIndex = 1;
                        Iterator iterator = instanceNetworkInterfaceSpecificationGroupsList.iterator();
                        while (iterator.hasNext()) {
                            String instanceNetworkInterfaceSpecificationGroupsListValue = (String)iterator.next();
                            if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.ipv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                        int ipv6AddressesListIndex = 1;
                        for (InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue : instanceNetworkInterfaceSpecificationIpv6AddressesList) {
                            if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.privateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                        int privateIpAddressesListIndex = 1;
                        for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                            }
                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress()));
                            }
                            ++privateIpAddressesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.subnetId()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((placement = launchSpecification.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.availabilityZone()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.groupName()));
                }
                if (placement.tenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString((String)placement.tenancy()));
                }
            }
            if (launchSpecification.ramdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString((String)launchSpecification.ramdiskId()));
            }
            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.subnetId()));
            }
            if (!(launchSpecificationAllSecurityGroupsList = (SdkInternalList)launchSpecification.allSecurityGroups()).isEmpty() || !launchSpecificationAllSecurityGroupsList.isAutoConstruct()) {
                int allSecurityGroupsListIndex = 1;
                for (GroupIdentifier launchSpecificationAllSecurityGroupsListValue : launchSpecificationAllSecurityGroupsList) {
                    if (launchSpecificationAllSecurityGroupsListValue.groupName() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupName", StringUtils.fromString((String)launchSpecificationAllSecurityGroupsListValue.groupName()));
                    }
                    if (launchSpecificationAllSecurityGroupsListValue.groupId() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupId", StringUtils.fromString((String)launchSpecificationAllSecurityGroupsListValue.groupId()));
                    }
                    ++allSecurityGroupsListIndex;
                }
            }
            if (launchSpecification.monitoringEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecification.monitoringEnabled()));
            }
            if (!(launchSpecificationSecurityGroupsList = (SdkInternalList)launchSpecification.securityGroups()).isEmpty() || !launchSpecificationSecurityGroupsList.isAutoConstruct()) {
                int securityGroupsListIndex = 1;
                for (String launchSpecificationSecurityGroupsListValue : launchSpecificationSecurityGroupsList) {
                    if (launchSpecificationSecurityGroupsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)launchSpecificationSecurityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        if (requestSpotInstancesRequest.spotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString((String)requestSpotInstancesRequest.spotPrice()));
        }
        if (requestSpotInstancesRequest.type() != null) {
            request.addParameter("Type", StringUtils.fromString((String)requestSpotInstancesRequest.type()));
        }
        if (requestSpotInstancesRequest.validFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate((Date)requestSpotInstancesRequest.validFrom()));
        }
        if (requestSpotInstancesRequest.validUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate((Date)requestSpotInstancesRequest.validUntil()));
        }
        return request;
    }
}

