/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ReleaseHostsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ReleaseHostsRequestMarshaller
implements Marshaller<Request<ReleaseHostsRequest>, ReleaseHostsRequest> {
    public Request<ReleaseHostsRequest> marshall(ReleaseHostsRequest releaseHostsRequest) {
        if (releaseHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)releaseHostsRequest, "EC2Client");
        request.addParameter("Action", "ReleaseHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList releaseHostsRequestHostIdsList = (SdkInternalList)releaseHostsRequest.hostIds();
        if (!releaseHostsRequestHostIdsList.isEmpty() || !releaseHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;
            for (String releaseHostsRequestHostIdsListValue : releaseHostsRequestHostIdsList) {
                if (releaseHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString((String)releaseHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        return request;
    }
}

