/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PrefixList;

public class PrefixListUnmarshaller
implements Unmarshaller<PrefixList, StaxUnmarshallerContext> {
    private static PrefixListUnmarshaller INSTANCE;

    public PrefixList unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PrefixList.Builder prefixList = PrefixList.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("cidrSet", targetDepth)) {
                    prefixList.cidrs(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("cidrSet/item", targetDepth)) {
                    prefixList.cidrs(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("prefixListId", targetDepth)) {
                    prefixList.prefixListId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("prefixListName", targetDepth)) continue;
                prefixList.prefixListName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PrefixList)prefixList.build();
    }

    public static PrefixListUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PrefixListUnmarshaller();
        }
        return INSTANCE;
    }
}

