/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.MonitorInstancesRequest;
import software.amazon.awssdk.util.StringUtils;

public class MonitorInstancesRequestMarshaller
implements Marshaller<Request<MonitorInstancesRequest>, MonitorInstancesRequest> {
    public Request<MonitorInstancesRequest> marshall(MonitorInstancesRequest monitorInstancesRequest) {
        if (monitorInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)monitorInstancesRequest, "EC2Client");
        request.addParameter("Action", "MonitorInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList monitorInstancesRequestInstanceIdsList = (SdkInternalList)monitorInstancesRequest.instanceIds();
        if (!monitorInstancesRequestInstanceIdsList.isEmpty() || !monitorInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String monitorInstancesRequestInstanceIdsListValue : monitorInstancesRequestInstanceIdsList) {
                if (monitorInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)monitorInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

