/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DiskImage;
import software.amazon.awssdk.services.ec2.model.DiskImageDetail;
import software.amazon.awssdk.services.ec2.model.ImportInstanceLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ImportInstanceRequest;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.UserData;
import software.amazon.awssdk.services.ec2.model.VolumeDetail;
import software.amazon.awssdk.util.StringUtils;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        ImportInstanceLaunchSpecification launchSpecification;
        SdkInternalList importInstanceRequestDiskImagesList;
        if (importInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importInstanceRequest, "EC2Client");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (importInstanceRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importInstanceRequest.description()));
        }
        if (!(importInstanceRequestDiskImagesList = (SdkInternalList)importInstanceRequest.diskImages()).isEmpty() || !importInstanceRequestDiskImagesList.isAutoConstruct()) {
            int diskImagesListIndex = 1;
            for (DiskImage importInstanceRequestDiskImagesListValue : importInstanceRequestDiskImagesList) {
                VolumeDetail volume;
                Object image;
                if (importInstanceRequestDiskImagesListValue.description() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringUtils.fromString((String)importInstanceRequestDiskImagesListValue.description()));
                }
                if ((image = importInstanceRequestDiskImagesListValue.image()) != null) {
                    if (((DiskImageDetail)image).bytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringUtils.fromLong((Long)((DiskImageDetail)image).bytes()));
                    }
                    if (((DiskImageDetail)image).format() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringUtils.fromString((String)((DiskImageDetail)image).format()));
                    }
                    if (((DiskImageDetail)image).importManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringUtils.fromString((String)((DiskImageDetail)image).importManifestUrl()));
                    }
                }
                if ((volume = importInstanceRequestDiskImagesListValue.volume()) != null && volume.size() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringUtils.fromLong((Long)volume.size()));
                }
                ++diskImagesListIndex;
            }
        }
        if ((launchSpecification = importInstanceRequest.launchSpecification()) != null) {
            UserData userData;
            Placement placement;
            SdkInternalList importInstanceLaunchSpecificationGroupNamesList;
            SdkInternalList importInstanceLaunchSpecificationGroupIdsList;
            if (launchSpecification.additionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringUtils.fromString((String)launchSpecification.additionalInfo()));
            }
            if (launchSpecification.architecture() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringUtils.fromString((String)launchSpecification.architecture()));
            }
            if (!(importInstanceLaunchSpecificationGroupIdsList = (SdkInternalList)launchSpecification.groupIds()).isEmpty() || !importInstanceLaunchSpecificationGroupIdsList.isAutoConstruct()) {
                int groupIdsListIndex = 1;
                for (Object importInstanceLaunchSpecificationGroupIdsListValue : importInstanceLaunchSpecificationGroupIdsList) {
                    if (importInstanceLaunchSpecificationGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringUtils.fromString((String)importInstanceLaunchSpecificationGroupIdsListValue));
                    }
                    ++groupIdsListIndex;
                }
            }
            if (!(importInstanceLaunchSpecificationGroupNamesList = (SdkInternalList)launchSpecification.groupNames()).isEmpty() || !importInstanceLaunchSpecificationGroupNamesList.isAutoConstruct()) {
                int groupNamesListIndex = 1;
                for (String importInstanceLaunchSpecificationGroupNamesListValue : importInstanceLaunchSpecificationGroupNamesList) {
                    if (importInstanceLaunchSpecificationGroupNamesListValue != null) {
                        request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringUtils.fromString((String)importInstanceLaunchSpecificationGroupNamesListValue));
                    }
                    ++groupNamesListIndex;
                }
            }
            if (launchSpecification.instanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)launchSpecification.instanceInitiatedShutdownBehavior()));
            }
            if (launchSpecification.instanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.instanceType()));
            }
            if (launchSpecification.monitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecification.monitoring()));
            }
            if ((placement = launchSpecification.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.availabilityZone()));
                }
                if (placement.affinity() != null) {
                    request.addParameter("LaunchSpecification.Placement.Affinity", StringUtils.fromString((String)placement.affinity()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.groupName()));
                }
                if (placement.hostId() != null) {
                    request.addParameter("LaunchSpecification.Placement.HostId", StringUtils.fromString((String)placement.hostId()));
                }
                if (placement.tenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString((String)placement.tenancy()));
                }
                if (placement.spreadDomain() != null) {
                    request.addParameter("LaunchSpecification.Placement.SpreadDomain", StringUtils.fromString((String)placement.spreadDomain()));
                }
            }
            if (launchSpecification.privateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringUtils.fromString((String)launchSpecification.privateIpAddress()));
            }
            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.subnetId()));
            }
            if ((userData = launchSpecification.userData()) != null && userData.data() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString((String)userData.data()));
            }
        }
        if (importInstanceRequest.platform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importInstanceRequest.platform()));
        }
        return request;
    }
}

