/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ImageAttribute;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchPermissionUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ProductCodeUnmarshaller;

public class ImageAttributeUnmarshaller
implements Unmarshaller<ImageAttribute, StaxUnmarshallerContext> {
    private static ImageAttributeUnmarshaller INSTANCE;

    public ImageAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ImageAttribute.Builder imageAttribute = ImageAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    imageAttribute.blockDeviceMappings(new ArrayList<BlockDeviceMapping>());
                    continue;
                }
                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    imageAttribute.blockDeviceMappings(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageId", targetDepth)) {
                    imageAttribute.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("launchPermission", targetDepth)) {
                    imageAttribute.launchPermissions(new ArrayList<LaunchPermission>());
                    continue;
                }
                if (context.testExpression("launchPermission/item", targetDepth)) {
                    imageAttribute.launchPermissions(LaunchPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("productCodes", targetDepth)) {
                    imageAttribute.productCodes(new ArrayList<ProductCode>());
                    continue;
                }
                if (context.testExpression("productCodes/item", targetDepth)) {
                    imageAttribute.productCodes(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description/value", targetDepth)) {
                    imageAttribute.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("kernel/value", targetDepth)) {
                    imageAttribute.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ramdisk/value", targetDepth)) {
                    imageAttribute.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("sriovNetSupport/value", targetDepth)) continue;
                imageAttribute.sriovNetSupport(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ImageAttribute)imageAttribute.build();
    }

    public static ImageAttributeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImageAttributeUnmarshaller();
        }
        return INSTANCE;
    }
}

