/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.FpgaImage;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.FpgaImageStateUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PciIdUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ProductCodeUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class FpgaImageUnmarshaller
implements Unmarshaller<FpgaImage, StaxUnmarshallerContext> {
    private static FpgaImageUnmarshaller INSTANCE;

    public FpgaImage unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        FpgaImage.Builder fpgaImage = FpgaImage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("fpgaImageId", targetDepth)) {
                    fpgaImage.fpgaImageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("fpgaImageGlobalId", targetDepth)) {
                    fpgaImage.fpgaImageGlobalId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("name", targetDepth)) {
                    fpgaImage.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description", targetDepth)) {
                    fpgaImage.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("shellVersion", targetDepth)) {
                    fpgaImage.shellVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("pciId", targetDepth)) {
                    fpgaImage.pciId(PciIdUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    fpgaImage.state(FpgaImageStateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createTime", targetDepth)) {
                    fpgaImage.createTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("updateTime", targetDepth)) {
                    fpgaImage.updateTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    fpgaImage.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerAlias", targetDepth)) {
                    fpgaImage.ownerAlias(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("productCodes", targetDepth)) {
                    fpgaImage.productCodes(new ArrayList<ProductCode>());
                    continue;
                }
                if (context.testExpression("productCodes/item", targetDepth)) {
                    fpgaImage.productCodes(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tags", targetDepth)) {
                    fpgaImage.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tags/item", targetDepth)) continue;
                fpgaImage.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (FpgaImage)fpgaImage.build();
    }

    public static FpgaImageUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FpgaImageUnmarshaller();
        }
        return INSTANCE;
    }
}

