/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVpnGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVpnGatewaysRequestMarshaller
implements Marshaller<Request<DescribeVpnGatewaysRequest>, DescribeVpnGatewaysRequest> {
    public Request<DescribeVpnGatewaysRequest> marshall(DescribeVpnGatewaysRequest describeVpnGatewaysRequest) {
        SdkInternalList describeVpnGatewaysRequestVpnGatewayIdsList;
        if (describeVpnGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpnGatewaysRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpnGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpnGatewaysRequestFiltersList = (SdkInternalList)describeVpnGatewaysRequest.filters();
        if (!describeVpnGatewaysRequestFiltersList.isEmpty() || !describeVpnGatewaysRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpnGatewaysRequestFiltersListValue : describeVpnGatewaysRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpnGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpnGatewaysRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpnGatewaysRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpnGatewaysRequestVpnGatewayIdsList = (SdkInternalList)describeVpnGatewaysRequest.vpnGatewayIds()).isEmpty() || !describeVpnGatewaysRequestVpnGatewayIdsList.isAutoConstruct()) {
            int vpnGatewayIdsListIndex = 1;
            for (String describeVpnGatewaysRequestVpnGatewayIdsListValue : describeVpnGatewaysRequestVpnGatewayIdsList) {
                if (describeVpnGatewaysRequestVpnGatewayIdsListValue != null) {
                    request.addParameter("VpnGatewayId." + vpnGatewayIdsListIndex, StringUtils.fromString((String)describeVpnGatewaysRequestVpnGatewayIdsListValue));
                }
                ++vpnGatewayIdsListIndex;
            }
        }
        return request;
    }
}

