/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVolumeStatusRequestMarshaller
implements Marshaller<Request<DescribeVolumeStatusRequest>, DescribeVolumeStatusRequest> {
    public Request<DescribeVolumeStatusRequest> marshall(DescribeVolumeStatusRequest describeVolumeStatusRequest) {
        SdkInternalList describeVolumeStatusRequestVolumeIdsList;
        if (describeVolumeStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVolumeStatusRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumeStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVolumeStatusRequestFiltersList = (SdkInternalList)describeVolumeStatusRequest.filters();
        if (!describeVolumeStatusRequestFiltersList.isEmpty() || !describeVolumeStatusRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVolumeStatusRequestFiltersListValue : describeVolumeStatusRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVolumeStatusRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVolumeStatusRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVolumeStatusRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVolumeStatusRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVolumeStatusRequest.maxResults()));
        }
        if (describeVolumeStatusRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVolumeStatusRequest.nextToken()));
        }
        if (!(describeVolumeStatusRequestVolumeIdsList = (SdkInternalList)describeVolumeStatusRequest.volumeIds()).isEmpty() || !describeVolumeStatusRequestVolumeIdsList.isAutoConstruct()) {
            int volumeIdsListIndex = 1;
            for (String describeVolumeStatusRequestVolumeIdsListValue : describeVolumeStatusRequestVolumeIdsList) {
                if (describeVolumeStatusRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString((String)describeVolumeStatusRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        return request;
    }
}

