/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeReservedInstancesListingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesListingsRequest>, DescribeReservedInstancesListingsRequest> {
    public Request<DescribeReservedInstancesListingsRequest> marshall(DescribeReservedInstancesListingsRequest describeReservedInstancesListingsRequest) {
        if (describeReservedInstancesListingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesListingsRequest, "EC2Client");
        request.addParameter("Action", "DescribeReservedInstancesListings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeReservedInstancesListingsRequestFiltersList = (SdkInternalList)describeReservedInstancesListingsRequest.filters();
        if (!describeReservedInstancesListingsRequestFiltersList.isEmpty() || !describeReservedInstancesListingsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesListingsRequestFiltersListValue : describeReservedInstancesListingsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeReservedInstancesListingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeReservedInstancesListingsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeReservedInstancesListingsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesListingsRequest.reservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString((String)describeReservedInstancesListingsRequest.reservedInstancesId()));
        }
        if (describeReservedInstancesListingsRequest.reservedInstancesListingId() != null) {
            request.addParameter("ReservedInstancesListingId", StringUtils.fromString((String)describeReservedInstancesListingsRequest.reservedInstancesListingId()));
        }
        return request;
    }
}

