/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeKeyPairsRequestMarshaller
implements Marshaller<Request<DescribeKeyPairsRequest>, DescribeKeyPairsRequest> {
    public Request<DescribeKeyPairsRequest> marshall(DescribeKeyPairsRequest describeKeyPairsRequest) {
        SdkInternalList describeKeyPairsRequestKeyNamesList;
        if (describeKeyPairsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeKeyPairsRequest, "EC2Client");
        request.addParameter("Action", "DescribeKeyPairs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeKeyPairsRequestFiltersList = (SdkInternalList)describeKeyPairsRequest.filters();
        if (!describeKeyPairsRequestFiltersList.isEmpty() || !describeKeyPairsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeKeyPairsRequestFiltersListValue : describeKeyPairsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeKeyPairsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeKeyPairsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeKeyPairsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeKeyPairsRequestKeyNamesList = (SdkInternalList)describeKeyPairsRequest.keyNames()).isEmpty() || !describeKeyPairsRequestKeyNamesList.isAutoConstruct()) {
            int keyNamesListIndex = 1;
            for (String describeKeyPairsRequestKeyNamesListValue : describeKeyPairsRequestKeyNamesList) {
                if (describeKeyPairsRequestKeyNamesListValue != null) {
                    request.addParameter("KeyName." + keyNamesListIndex, StringUtils.fromString((String)describeKeyPairsRequestKeyNamesListValue));
                }
                ++keyNamesListIndex;
            }
        }
        return request;
    }
}

