/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeInstanceStatusRequestMarshaller
implements Marshaller<Request<DescribeInstanceStatusRequest>, DescribeInstanceStatusRequest> {
    public Request<DescribeInstanceStatusRequest> marshall(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        SdkInternalList describeInstanceStatusRequestInstanceIdsList;
        if (describeInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceStatusRequest, "EC2Client");
        request.addParameter("Action", "DescribeInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeInstanceStatusRequestFiltersList = (SdkInternalList)describeInstanceStatusRequest.filters();
        if (!describeInstanceStatusRequestFiltersList.isEmpty() || !describeInstanceStatusRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceStatusRequestFiltersListValue : describeInstanceStatusRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceStatusRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInstanceStatusRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceStatusRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInstanceStatusRequestInstanceIdsList = (SdkInternalList)describeInstanceStatusRequest.instanceIds()).isEmpty() || !describeInstanceStatusRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String describeInstanceStatusRequestInstanceIdsListValue : describeInstanceStatusRequestInstanceIdsList) {
                if (describeInstanceStatusRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)describeInstanceStatusRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeInstanceStatusRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeInstanceStatusRequest.maxResults()));
        }
        if (describeInstanceStatusRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstanceStatusRequest.nextToken()));
        }
        if (describeInstanceStatusRequest.includeAllInstances() != null) {
            request.addParameter("IncludeAllInstances", StringUtils.fromBoolean((Boolean)describeInstanceStatusRequest.includeAllInstances()));
        }
        return request;
    }
}

