/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeIamInstanceProfileAssociationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeIamInstanceProfileAssociationsRequestMarshaller
implements Marshaller<Request<DescribeIamInstanceProfileAssociationsRequest>, DescribeIamInstanceProfileAssociationsRequest> {
    public Request<DescribeIamInstanceProfileAssociationsRequest> marshall(DescribeIamInstanceProfileAssociationsRequest describeIamInstanceProfileAssociationsRequest) {
        SdkInternalList describeIamInstanceProfileAssociationsRequestFiltersList;
        if (describeIamInstanceProfileAssociationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIamInstanceProfileAssociationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeIamInstanceProfileAssociations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeIamInstanceProfileAssociationsRequestAssociationIdsList = (SdkInternalList)describeIamInstanceProfileAssociationsRequest.associationIds();
        if (!describeIamInstanceProfileAssociationsRequestAssociationIdsList.isEmpty() || !describeIamInstanceProfileAssociationsRequestAssociationIdsList.isAutoConstruct()) {
            int associationIdsListIndex = 1;
            for (String describeIamInstanceProfileAssociationsRequestAssociationIdsListValue : describeIamInstanceProfileAssociationsRequestAssociationIdsList) {
                if (describeIamInstanceProfileAssociationsRequestAssociationIdsListValue != null) {
                    request.addParameter("AssociationId." + associationIdsListIndex, StringUtils.fromString((String)describeIamInstanceProfileAssociationsRequestAssociationIdsListValue));
                }
                ++associationIdsListIndex;
            }
        }
        if (!(describeIamInstanceProfileAssociationsRequestFiltersList = (SdkInternalList)describeIamInstanceProfileAssociationsRequest.filters()).isEmpty() || !describeIamInstanceProfileAssociationsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeIamInstanceProfileAssociationsRequestFiltersListValue : describeIamInstanceProfileAssociationsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeIamInstanceProfileAssociationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeIamInstanceProfileAssociationsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeIamInstanceProfileAssociationsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIamInstanceProfileAssociationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeIamInstanceProfileAssociationsRequest.maxResults()));
        }
        if (describeIamInstanceProfileAssociationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeIamInstanceProfileAssociationsRequest.nextToken()));
        }
        return request;
    }
}

