/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAccountAttributesRequestMarshaller
implements Marshaller<Request<DescribeAccountAttributesRequest>, DescribeAccountAttributesRequest> {
    public Request<DescribeAccountAttributesRequest> marshall(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        if (describeAccountAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAccountAttributesRequest, "EC2Client");
        request.addParameter("Action", "DescribeAccountAttributes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeAccountAttributesRequestAttributeNamesList = (SdkInternalList)describeAccountAttributesRequest.attributeNames();
        if (!describeAccountAttributesRequestAttributeNamesList.isEmpty() || !describeAccountAttributesRequestAttributeNamesList.isAutoConstruct()) {
            int attributeNamesListIndex = 1;
            for (String describeAccountAttributesRequestAttributeNamesListValue : describeAccountAttributesRequestAttributeNamesList) {
                if (describeAccountAttributesRequestAttributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString((String)describeAccountAttributesRequestAttributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        return request;
    }
}

