/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateVpcEndpointRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointRequest>, CreateVpcEndpointRequest> {
    public Request<CreateVpcEndpointRequest> marshall(CreateVpcEndpointRequest createVpcEndpointRequest) {
        SdkInternalList createVpcEndpointRequestRouteTableIdsList;
        if (createVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpcEndpointRequest, "EC2Client");
        request.addParameter("Action", "CreateVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createVpcEndpointRequest.clientToken()));
        }
        if (createVpcEndpointRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createVpcEndpointRequest.policyDocument()));
        }
        if (!(createVpcEndpointRequestRouteTableIdsList = (SdkInternalList)createVpcEndpointRequest.routeTableIds()).isEmpty() || !createVpcEndpointRequestRouteTableIdsList.isAutoConstruct()) {
            int routeTableIdsListIndex = 1;
            for (String createVpcEndpointRequestRouteTableIdsListValue : createVpcEndpointRequestRouteTableIdsList) {
                if (createVpcEndpointRequestRouteTableIdsListValue != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString((String)createVpcEndpointRequestRouteTableIdsListValue));
                }
                ++routeTableIdsListIndex;
            }
        }
        if (createVpcEndpointRequest.serviceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString((String)createVpcEndpointRequest.serviceName()));
        }
        if (createVpcEndpointRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createVpcEndpointRequest.vpcId()));
        }
        return request;
    }
}

