/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateNetworkInterfaceRequest;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.util.StringUtils;

public class CreateNetworkInterfaceRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {
    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        SdkInternalList createNetworkInterfaceRequestPrivateIpAddressesList;
        SdkInternalList createNetworkInterfaceRequestIpv6AddressesList;
        SdkInternalList createNetworkInterfaceRequestGroupsList;
        if (createNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkInterfaceRequest, "EC2Client");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInterfaceRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createNetworkInterfaceRequest.description()));
        }
        if (!(createNetworkInterfaceRequestGroupsList = (SdkInternalList)createNetworkInterfaceRequest.groups()).isEmpty() || !createNetworkInterfaceRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (Object createNetworkInterfaceRequestGroupsListValue : createNetworkInterfaceRequestGroupsList) {
                if (createNetworkInterfaceRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)createNetworkInterfaceRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (createNetworkInterfaceRequest.ipv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.ipv6AddressCount()));
        }
        if (!(createNetworkInterfaceRequestIpv6AddressesList = (SdkInternalList)createNetworkInterfaceRequest.ipv6Addresses()).isEmpty() || !createNetworkInterfaceRequestIpv6AddressesList.isAutoConstruct()) {
            int ipv6AddressesListIndex = 1;
            for (InstanceIpv6Address createNetworkInterfaceRequestIpv6AddressesListValue : createNetworkInterfaceRequestIpv6AddressesList) {
                if (createNetworkInterfaceRequestIpv6AddressesListValue.ipv6Address() != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)createNetworkInterfaceRequestIpv6AddressesListValue.ipv6Address()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.privateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequest.privateIpAddress()));
        }
        if (!(createNetworkInterfaceRequestPrivateIpAddressesList = (SdkInternalList)createNetworkInterfaceRequest.privateIpAddresses()).isEmpty() || !createNetworkInterfaceRequestPrivateIpAddressesList.isAutoConstruct()) {
            int privateIpAddressesListIndex = 1;
            for (PrivateIpAddressSpecification createNetworkInterfaceRequestPrivateIpAddressesListValue : createNetworkInterfaceRequestPrivateIpAddressesList) {
                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.primary() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)createNetworkInterfaceRequestPrivateIpAddressesListValue.primary()));
                }
                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.privateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequestPrivateIpAddressesListValue.privateIpAddress()));
                }
                ++privateIpAddressesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.secondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.secondaryPrivateIpAddressCount()));
        }
        if (createNetworkInterfaceRequest.subnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNetworkInterfaceRequest.subnetId()));
        }
        return request;
    }
}

