/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest;
import software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification;
import software.amazon.awssdk.util.StringUtils;

public class CreateInstanceExportTaskRequestMarshaller
implements Marshaller<Request<CreateInstanceExportTaskRequest>, CreateInstanceExportTaskRequest> {
    public Request<CreateInstanceExportTaskRequest> marshall(CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        ExportToS3TaskSpecification exportToS3Task;
        if (createInstanceExportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceExportTaskRequest, "EC2Client");
        request.addParameter("Action", "CreateInstanceExportTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceExportTaskRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createInstanceExportTaskRequest.description()));
        }
        if ((exportToS3Task = createInstanceExportTaskRequest.exportToS3Task()) != null) {
            if (exportToS3Task.containerFormat() != null) {
                request.addParameter("ExportToS3.ContainerFormat", StringUtils.fromString((String)exportToS3Task.containerFormat()));
            }
            if (exportToS3Task.diskImageFormat() != null) {
                request.addParameter("ExportToS3.DiskImageFormat", StringUtils.fromString((String)exportToS3Task.diskImageFormat()));
            }
            if (exportToS3Task.s3Bucket() != null) {
                request.addParameter("ExportToS3.S3Bucket", StringUtils.fromString((String)exportToS3Task.s3Bucket()));
            }
            if (exportToS3Task.s3Prefix() != null) {
                request.addParameter("ExportToS3.S3Prefix", StringUtils.fromString((String)exportToS3Task.s3Prefix()));
            }
        }
        if (createInstanceExportTaskRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createInstanceExportTaskRequest.instanceId()));
        }
        if (createInstanceExportTaskRequest.targetEnvironment() != null) {
            request.addParameter("TargetEnvironment", StringUtils.fromString((String)createInstanceExportTaskRequest.targetEnvironment()));
        }
        return request;
    }
}

