/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CancelConversionTaskRequest;
import software.amazon.awssdk.util.StringUtils;

public class CancelConversionTaskRequestMarshaller
implements Marshaller<Request<CancelConversionTaskRequest>, CancelConversionTaskRequest> {
    public Request<CancelConversionTaskRequest> marshall(CancelConversionTaskRequest cancelConversionTaskRequest) {
        if (cancelConversionTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelConversionTaskRequest, "EC2Client");
        request.addParameter("Action", "CancelConversionTask");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (cancelConversionTaskRequest.conversionTaskId() != null) {
            request.addParameter("ConversionTaskId", StringUtils.fromString((String)cancelConversionTaskRequest.conversionTaskId()));
        }
        if (cancelConversionTaskRequest.reasonMessage() != null) {
            request.addParameter("ReasonMessage", StringUtils.fromString((String)cancelConversionTaskRequest.reasonMessage()));
        }
        return request;
    }
}

