/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.AccountAttribute;
import software.amazon.awssdk.services.ec2.model.AccountAttributeValue;
import software.amazon.awssdk.services.ec2.transform.AccountAttributeValueUnmarshaller;

public class AccountAttributeUnmarshaller
implements Unmarshaller<AccountAttribute, StaxUnmarshallerContext> {
    private static AccountAttributeUnmarshaller INSTANCE;

    public AccountAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AccountAttribute.Builder accountAttribute = AccountAttribute.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("attributeName", targetDepth)) {
                    accountAttribute.attributeName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("attributeValueSet", targetDepth)) {
                    accountAttribute.attributeValues(new ArrayList<AccountAttributeValue>());
                    continue;
                }
                if (!context.testExpression("attributeValueSet/item", targetDepth)) continue;
                accountAttribute.attributeValues(AccountAttributeValueUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AccountAttribute)accountAttribute.build();
    }

    public static AccountAttributeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AccountAttributeUnmarshaller();
        }
        return INSTANCE;
    }
}

