/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.State;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcEndpoint
implements ToCopyableBuilder<Builder, VpcEndpoint> {
    private final Date creationTimestamp;
    private final String policyDocument;
    private final List<String> routeTableIds;
    private final String serviceName;
    private final String state;
    private final String vpcEndpointId;
    private final String vpcId;

    private VpcEndpoint(BuilderImpl builder) {
        this.creationTimestamp = builder.creationTimestamp;
        this.policyDocument = builder.policyDocument;
        this.routeTableIds = builder.routeTableIds;
        this.serviceName = builder.serviceName;
        this.state = builder.state;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcId = builder.vpcId;
    }

    public Date creationTimestamp() {
        return this.creationTimestamp;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String state() {
        return this.state;
    }

    public String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.creationTimestamp() == null ? 0 : this.creationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.policyDocument() == null ? 0 : this.policyDocument().hashCode());
        hashCode = 31 * hashCode + (this.routeTableIds() == null ? 0 : this.routeTableIds().hashCode());
        hashCode = 31 * hashCode + (this.serviceName() == null ? 0 : this.serviceName().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.vpcEndpointId() == null ? 0 : this.vpcEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint)obj;
        if (other.creationTimestamp() == null ^ this.creationTimestamp() == null) {
            return false;
        }
        if (other.creationTimestamp() != null && !other.creationTimestamp().equals(this.creationTimestamp())) {
            return false;
        }
        if (other.policyDocument() == null ^ this.policyDocument() == null) {
            return false;
        }
        if (other.policyDocument() != null && !other.policyDocument().equals(this.policyDocument())) {
            return false;
        }
        if (other.routeTableIds() == null ^ this.routeTableIds() == null) {
            return false;
        }
        if (other.routeTableIds() != null && !other.routeTableIds().equals(this.routeTableIds())) {
            return false;
        }
        if (other.serviceName() == null ^ this.serviceName() == null) {
            return false;
        }
        if (other.serviceName() != null && !other.serviceName().equals(this.serviceName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcEndpointId() == null ^ this.vpcEndpointId() == null) {
            return false;
        }
        if (other.vpcEndpointId() != null && !other.vpcEndpointId().equals(this.vpcEndpointId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.creationTimestamp() != null) {
            sb.append("CreationTimestamp: ").append(this.creationTimestamp()).append(",");
        }
        if (this.policyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.policyDocument()).append(",");
        }
        if (this.routeTableIds() != null) {
            sb.append("RouteTableIds: ").append(this.routeTableIds()).append(",");
        }
        if (this.serviceName() != null) {
            sb.append("ServiceName: ").append(this.serviceName()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.vpcEndpointId() != null) {
            sb.append("VpcEndpointId: ").append(this.vpcEndpointId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Date creationTimestamp;
        private String policyDocument;
        private List<String> routeTableIds = new SdkInternalList();
        private String serviceName;
        private String state;
        private String vpcEndpointId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            this.setCreationTimestamp(model.creationTimestamp);
            this.setPolicyDocument(model.policyDocument);
            this.setRouteTableIds(model.routeTableIds);
            this.setServiceName(model.serviceName);
            this.setState(model.state);
            this.setVpcEndpointId(model.vpcEndpointId);
            this.setVpcId(model.vpcId);
        }

        public final Date getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Date creationTimestamp) {
            this.creationTimestamp = StandardMemberCopier.copy((Date)creationTimestamp);
            return this;
        }

        public final void setCreationTimestamp(Date creationTimestamp) {
            this.creationTimestamp = StandardMemberCopier.copy((Date)creationTimestamp);
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            if (this.routeTableIds == null) {
                this.routeTableIds = new SdkInternalList(routeTableIds.length);
            }
            for (String e : routeTableIds) {
                this.routeTableIds.add(e);
            }
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        @SafeVarargs
        public final void setRouteTableIds(String ... routeTableIds) {
            if (this.routeTableIds == null) {
                this.routeTableIds = new SdkInternalList(routeTableIds.length);
            }
            for (String e : routeTableIds) {
                this.routeTableIds.add(e);
            }
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(State state) {
            this.state(state.toString());
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcEndpoint> {
        public Builder creationTimestamp(Date var1);

        public Builder policyDocument(String var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);

        public Builder serviceName(String var1);

        public Builder state(String var1);

        public Builder state(State var1);

        public Builder vpcEndpointId(String var1);

        public Builder vpcId(String var1);
    }
}

