/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesId;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResultListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedIntancesIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesModification
implements ToCopyableBuilder<Builder, ReservedInstancesModification> {
    private final String clientToken;
    private final Date createDate;
    private final Date effectiveDate;
    private final List<ReservedInstancesModificationResult> modificationResults;
    private final List<ReservedInstancesId> reservedInstancesIds;
    private final String reservedInstancesModificationId;
    private final String status;
    private final String statusMessage;
    private final Date updateDate;

    private ReservedInstancesModification(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.effectiveDate = builder.effectiveDate;
        this.modificationResults = builder.modificationResults;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.reservedInstancesModificationId = builder.reservedInstancesModificationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.updateDate = builder.updateDate;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Date createDate() {
        return this.createDate;
    }

    public Date effectiveDate() {
        return this.effectiveDate;
    }

    public List<ReservedInstancesModificationResult> modificationResults() {
        return this.modificationResults;
    }

    public List<ReservedInstancesId> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public String reservedInstancesModificationId() {
        return this.reservedInstancesModificationId;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Date updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.effectiveDate() == null ? 0 : this.effectiveDate().hashCode());
        hashCode = 31 * hashCode + (this.modificationResults() == null ? 0 : this.modificationResults().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesIds() == null ? 0 : this.reservedInstancesIds().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesModificationId() == null ? 0 : this.reservedInstancesModificationId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        hashCode = 31 * hashCode + (this.updateDate() == null ? 0 : this.updateDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModification)) {
            return false;
        }
        ReservedInstancesModification other = (ReservedInstancesModification)obj;
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.effectiveDate() == null ^ this.effectiveDate() == null) {
            return false;
        }
        if (other.effectiveDate() != null && !other.effectiveDate().equals(this.effectiveDate())) {
            return false;
        }
        if (other.modificationResults() == null ^ this.modificationResults() == null) {
            return false;
        }
        if (other.modificationResults() != null && !other.modificationResults().equals(this.modificationResults())) {
            return false;
        }
        if (other.reservedInstancesIds() == null ^ this.reservedInstancesIds() == null) {
            return false;
        }
        if (other.reservedInstancesIds() != null && !other.reservedInstancesIds().equals(this.reservedInstancesIds())) {
            return false;
        }
        if (other.reservedInstancesModificationId() == null ^ this.reservedInstancesModificationId() == null) {
            return false;
        }
        if (other.reservedInstancesModificationId() != null && !other.reservedInstancesModificationId().equals(this.reservedInstancesModificationId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.updateDate() == null ^ this.updateDate() == null) {
            return false;
        }
        return other.updateDate() == null || other.updateDate().equals(this.updateDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.effectiveDate() != null) {
            sb.append("EffectiveDate: ").append(this.effectiveDate()).append(",");
        }
        if (this.modificationResults() != null) {
            sb.append("ModificationResults: ").append(this.modificationResults()).append(",");
        }
        if (this.reservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(this.reservedInstancesIds()).append(",");
        }
        if (this.reservedInstancesModificationId() != null) {
            sb.append("ReservedInstancesModificationId: ").append(this.reservedInstancesModificationId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.updateDate() != null) {
            sb.append("UpdateDate: ").append(this.updateDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Date createDate;
        private Date effectiveDate;
        private List<ReservedInstancesModificationResult> modificationResults = new SdkInternalList();
        private List<ReservedInstancesId> reservedInstancesIds = new SdkInternalList();
        private String reservedInstancesModificationId;
        private String status;
        private String statusMessage;
        private Date updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModification model) {
            this.setClientToken(model.clientToken);
            this.setCreateDate(model.createDate);
            this.setEffectiveDate(model.effectiveDate);
            this.setModificationResults(model.modificationResults);
            this.setReservedInstancesIds(model.reservedInstancesIds);
            this.setReservedInstancesModificationId(model.reservedInstancesModificationId);
            this.setStatus(model.status);
            this.setStatusMessage(model.statusMessage);
            this.setUpdateDate(model.updateDate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy((Date)createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy((Date)createDate);
        }

        public final Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Date effectiveDate) {
            this.effectiveDate = StandardMemberCopier.copy((Date)effectiveDate);
            return this;
        }

        public final void setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = StandardMemberCopier.copy((Date)effectiveDate);
        }

        public final Collection<ReservedInstancesModificationResult> getModificationResults() {
            return this.modificationResults;
        }

        @Override
        public final Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copy(modificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(ReservedInstancesModificationResult ... modificationResults) {
            if (this.modificationResults == null) {
                this.modificationResults = new SdkInternalList(modificationResults.length);
            }
            for (ReservedInstancesModificationResult e : modificationResults) {
                this.modificationResults.add(e);
            }
            return this;
        }

        public final void setModificationResults(Collection<ReservedInstancesModificationResult> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copy(modificationResults);
        }

        @SafeVarargs
        public final void setModificationResults(ReservedInstancesModificationResult ... modificationResults) {
            if (this.modificationResults == null) {
                this.modificationResults = new SdkInternalList(modificationResults.length);
            }
            for (ReservedInstancesModificationResult e : modificationResults) {
                this.modificationResults.add(e);
            }
        }

        public final Collection<ReservedInstancesId> getReservedInstancesIds() {
            return this.reservedInstancesIds;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(ReservedInstancesId ... reservedInstancesIds) {
            if (this.reservedInstancesIds == null) {
                this.reservedInstancesIds = new SdkInternalList(reservedInstancesIds.length);
            }
            for (ReservedInstancesId e : reservedInstancesIds) {
                this.reservedInstancesIds.add(e);
            }
            return this;
        }

        public final void setReservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copy(reservedInstancesIds);
        }

        @SafeVarargs
        public final void setReservedInstancesIds(ReservedInstancesId ... reservedInstancesIds) {
            if (this.reservedInstancesIds == null) {
                this.reservedInstancesIds = new SdkInternalList(reservedInstancesIds.length);
            }
            for (ReservedInstancesId e : reservedInstancesIds) {
                this.reservedInstancesIds.add(e);
            }
        }

        public final String getReservedInstancesModificationId() {
            return this.reservedInstancesModificationId;
        }

        @Override
        public final Builder reservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
            return this;
        }

        public final void setReservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Date getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Date updateDate) {
            this.updateDate = StandardMemberCopier.copy((Date)updateDate);
            return this;
        }

        public final void setUpdateDate(Date updateDate) {
            this.updateDate = StandardMemberCopier.copy((Date)updateDate);
        }

        public ReservedInstancesModification build() {
            return new ReservedInstancesModification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesModification> {
        public Builder clientToken(String var1);

        public Builder createDate(Date var1);

        public Builder effectiveDate(Date var1);

        public Builder modificationResults(Collection<ReservedInstancesModificationResult> var1);

        public Builder modificationResults(ReservedInstancesModificationResult ... var1);

        public Builder reservedInstancesIds(Collection<ReservedInstancesId> var1);

        public Builder reservedInstancesIds(ReservedInstancesId ... var1);

        public Builder reservedInstancesModificationId(String var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder updateDate(Date var1);
    }
}

