/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.InstanceCount;
import software.amazon.awssdk.services.ec2.model.InstanceCountListCopier;
import software.amazon.awssdk.services.ec2.model.ListingStatus;
import software.amazon.awssdk.services.ec2.model.PriceSchedule;
import software.amazon.awssdk.services.ec2.model.PriceScheduleListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstancesListing
implements ToCopyableBuilder<Builder, ReservedInstancesListing> {
    private final String clientToken;
    private final Date createDate;
    private final List<InstanceCount> instanceCounts;
    private final List<PriceSchedule> priceSchedules;
    private final String reservedInstancesId;
    private final String reservedInstancesListingId;
    private final String status;
    private final String statusMessage;
    private final List<Tag> tags;
    private final Date updateDate;

    private ReservedInstancesListing(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.instanceCounts = builder.instanceCounts;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.updateDate = builder.updateDate;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Date createDate() {
        return this.createDate;
    }

    public List<InstanceCount> instanceCounts() {
        return this.instanceCounts;
    }

    public List<PriceSchedule> priceSchedules() {
        return this.priceSchedules;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public String reservedInstancesListingId() {
        return this.reservedInstancesListingId;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Date updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.instanceCounts() == null ? 0 : this.instanceCounts().hashCode());
        hashCode = 31 * hashCode + (this.priceSchedules() == null ? 0 : this.priceSchedules().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesId() == null ? 0 : this.reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesListingId() == null ? 0 : this.reservedInstancesListingId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.updateDate() == null ? 0 : this.updateDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesListing)) {
            return false;
        }
        ReservedInstancesListing other = (ReservedInstancesListing)obj;
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.instanceCounts() == null ^ this.instanceCounts() == null) {
            return false;
        }
        if (other.instanceCounts() != null && !other.instanceCounts().equals(this.instanceCounts())) {
            return false;
        }
        if (other.priceSchedules() == null ^ this.priceSchedules() == null) {
            return false;
        }
        if (other.priceSchedules() != null && !other.priceSchedules().equals(this.priceSchedules())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.reservedInstancesListingId() == null ^ this.reservedInstancesListingId() == null) {
            return false;
        }
        if (other.reservedInstancesListingId() != null && !other.reservedInstancesListingId().equals(this.reservedInstancesListingId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        if (other.statusMessage() != null && !other.statusMessage().equals(this.statusMessage())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.updateDate() == null ^ this.updateDate() == null) {
            return false;
        }
        return other.updateDate() == null || other.updateDate().equals(this.updateDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.instanceCounts() != null) {
            sb.append("InstanceCounts: ").append(this.instanceCounts()).append(",");
        }
        if (this.priceSchedules() != null) {
            sb.append("PriceSchedules: ").append(this.priceSchedules()).append(",");
        }
        if (this.reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(this.reservedInstancesId()).append(",");
        }
        if (this.reservedInstancesListingId() != null) {
            sb.append("ReservedInstancesListingId: ").append(this.reservedInstancesListingId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.updateDate() != null) {
            sb.append("UpdateDate: ").append(this.updateDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Date createDate;
        private List<InstanceCount> instanceCounts = new SdkInternalList();
        private List<PriceSchedule> priceSchedules = new SdkInternalList();
        private String reservedInstancesId;
        private String reservedInstancesListingId;
        private String status;
        private String statusMessage;
        private List<Tag> tags = new SdkInternalList();
        private Date updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesListing model) {
            this.setClientToken(model.clientToken);
            this.setCreateDate(model.createDate);
            this.setInstanceCounts(model.instanceCounts);
            this.setPriceSchedules(model.priceSchedules);
            this.setReservedInstancesId(model.reservedInstancesId);
            this.setReservedInstancesListingId(model.reservedInstancesListingId);
            this.setStatus(model.status);
            this.setStatusMessage(model.statusMessage);
            this.setTags(model.tags);
            this.setUpdateDate(model.updateDate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy((Date)createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy((Date)createDate);
        }

        public final Collection<InstanceCount> getInstanceCounts() {
            return this.instanceCounts;
        }

        @Override
        public final Builder instanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(InstanceCount ... instanceCounts) {
            if (this.instanceCounts == null) {
                this.instanceCounts = new SdkInternalList(instanceCounts.length);
            }
            for (InstanceCount e : instanceCounts) {
                this.instanceCounts.add(e);
            }
            return this;
        }

        public final void setInstanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
        }

        @SafeVarargs
        public final void setInstanceCounts(InstanceCount ... instanceCounts) {
            if (this.instanceCounts == null) {
                this.instanceCounts = new SdkInternalList(instanceCounts.length);
            }
            for (InstanceCount e : instanceCounts) {
                this.instanceCounts.add(e);
            }
        }

        public final Collection<PriceSchedule> getPriceSchedules() {
            return this.priceSchedules;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceSchedule ... priceSchedules) {
            if (this.priceSchedules == null) {
                this.priceSchedules = new SdkInternalList(priceSchedules.length);
            }
            for (PriceSchedule e : priceSchedules) {
                this.priceSchedules.add(e);
            }
            return this;
        }

        public final void setPriceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
        }

        @SafeVarargs
        public final void setPriceSchedules(PriceSchedule ... priceSchedules) {
            if (this.priceSchedules == null) {
                this.priceSchedules = new SdkInternalList(priceSchedules.length);
            }
            for (PriceSchedule e : priceSchedules) {
                this.priceSchedules.add(e);
            }
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return this.reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ListingStatus status) {
            this.status(status.toString());
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final Date getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Date updateDate) {
            this.updateDate = StandardMemberCopier.copy((Date)updateDate);
            return this;
        }

        public final void setUpdateDate(Date updateDate) {
            this.updateDate = StandardMemberCopier.copy((Date)updateDate);
        }

        public ReservedInstancesListing build() {
            return new ReservedInstancesListing(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstancesListing> {
        public Builder clientToken(String var1);

        public Builder createDate(Date var1);

        public Builder instanceCounts(Collection<InstanceCount> var1);

        public Builder instanceCounts(InstanceCount ... var1);

        public Builder priceSchedules(Collection<PriceSchedule> var1);

        public Builder priceSchedules(PriceSchedule ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder reservedInstancesListingId(String var1);

        public Builder status(String var1);

        public Builder status(ListingStatus var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder updateDate(Date var1);
    }
}

