/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.RecurringChargesListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedInstanceState;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedInstances
implements ToCopyableBuilder<Builder, ReservedInstances> {
    private final String availabilityZone;
    private final Long duration;
    private final Date end;
    private final Float fixedPrice;
    private final Integer instanceCount;
    private final String instanceType;
    private final String productDescription;
    private final String reservedInstancesId;
    private final Date start;
    private final String state;
    private final Float usagePrice;
    private final String currencyCode;
    private final String instanceTenancy;
    private final String offeringClass;
    private final String offeringType;
    private final List<RecurringCharge> recurringCharges;
    private final String scope;
    private final List<Tag> tags;

    private ReservedInstances(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.duration = builder.duration;
        this.end = builder.end;
        this.fixedPrice = builder.fixedPrice;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.productDescription = builder.productDescription;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.start = builder.start;
        this.state = builder.state;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.instanceTenancy = builder.instanceTenancy;
        this.offeringClass = builder.offeringClass;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.scope = builder.scope;
        this.tags = builder.tags;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Long duration() {
        return this.duration;
    }

    public Date end() {
        return this.end;
    }

    public Float fixedPrice() {
        return this.fixedPrice;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public Date start() {
        return this.start;
    }

    public String state() {
        return this.state;
    }

    public Float usagePrice() {
        return this.usagePrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public String instanceTenancy() {
        return this.instanceTenancy;
    }

    public String offeringClass() {
        return this.offeringClass;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public String scope() {
        return this.scope;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.end() == null ? 0 : this.end().hashCode());
        hashCode = 31 * hashCode + (this.fixedPrice() == null ? 0 : this.fixedPrice().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.productDescription() == null ? 0 : this.productDescription().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesId() == null ? 0 : this.reservedInstancesId().hashCode());
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.usagePrice() == null ? 0 : this.usagePrice().hashCode());
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.instanceTenancy() == null ? 0 : this.instanceTenancy().hashCode());
        hashCode = 31 * hashCode + (this.offeringClass() == null ? 0 : this.offeringClass().hashCode());
        hashCode = 31 * hashCode + (this.offeringType() == null ? 0 : this.offeringType().hashCode());
        hashCode = 31 * hashCode + (this.recurringCharges() == null ? 0 : this.recurringCharges().hashCode());
        hashCode = 31 * hashCode + (this.scope() == null ? 0 : this.scope().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstances)) {
            return false;
        }
        ReservedInstances other = (ReservedInstances)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.reservedInstancesId() == null ^ this.reservedInstancesId() == null) {
            return false;
        }
        if (other.reservedInstancesId() != null && !other.reservedInstancesId().equals(this.reservedInstancesId())) {
            return false;
        }
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.offeringClass() == null ^ this.offeringClass() == null) {
            return false;
        }
        if (other.offeringClass() != null && !other.offeringClass().equals(this.offeringClass())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        if (other.recurringCharges() != null && !other.recurringCharges().equals(this.recurringCharges())) {
            return false;
        }
        if (other.scope() == null ^ this.scope() == null) {
            return false;
        }
        if (other.scope() != null && !other.scope().equals(this.scope())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.end() != null) {
            sb.append("End: ").append(this.end()).append(",");
        }
        if (this.fixedPrice() != null) {
            sb.append("FixedPrice: ").append(this.fixedPrice()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.productDescription() != null) {
            sb.append("ProductDescription: ").append(this.productDescription()).append(",");
        }
        if (this.reservedInstancesId() != null) {
            sb.append("ReservedInstancesId: ").append(this.reservedInstancesId()).append(",");
        }
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.usagePrice() != null) {
            sb.append("UsagePrice: ").append(this.usagePrice()).append(",");
        }
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancy()).append(",");
        }
        if (this.offeringClass() != null) {
            sb.append("OfferingClass: ").append(this.offeringClass()).append(",");
        }
        if (this.offeringType() != null) {
            sb.append("OfferingType: ").append(this.offeringType()).append(",");
        }
        if (this.recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.recurringCharges()).append(",");
        }
        if (this.scope() != null) {
            sb.append("Scope: ").append(this.scope()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Long duration;
        private Date end;
        private Float fixedPrice;
        private Integer instanceCount;
        private String instanceType;
        private String productDescription;
        private String reservedInstancesId;
        private Date start;
        private String state;
        private Float usagePrice;
        private String currencyCode;
        private String instanceTenancy;
        private String offeringClass;
        private String offeringType;
        private List<RecurringCharge> recurringCharges = new SdkInternalList();
        private String scope;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstances model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setDuration(model.duration);
            this.setEnd(model.end);
            this.setFixedPrice(model.fixedPrice);
            this.setInstanceCount(model.instanceCount);
            this.setInstanceType(model.instanceType);
            this.setProductDescription(model.productDescription);
            this.setReservedInstancesId(model.reservedInstancesId);
            this.setStart(model.start);
            this.setState(model.state);
            this.setUsagePrice(model.usagePrice);
            this.setCurrencyCode(model.currencyCode);
            this.setInstanceTenancy(model.instanceTenancy);
            this.setOfferingClass(model.offeringClass);
            this.setOfferingType(model.offeringType);
            this.setRecurringCharges(model.recurringCharges);
            this.setScope(model.scope);
            this.setTags(model.tags);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final Date getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
            return this;
        }

        public final void setEnd(Date end) {
            this.end = StandardMemberCopier.copy((Date)end);
        }

        public final Float getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Float fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final void setProductDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final Date getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
            return this;
        }

        public final void setStart(Date start) {
            this.start = StandardMemberCopier.copy((Date)start);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ReservedInstanceState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(ReservedInstanceState state) {
            this.state(state.toString());
        }

        public final Float getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Float usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final void setCurrencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final void setInstanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final void setOfferingClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final void setOfferingType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return this.recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            if (this.recurringCharges == null) {
                this.recurringCharges = new SdkInternalList(recurringCharges.length);
            }
            for (RecurringCharge e : recurringCharges) {
                this.recurringCharges.add(e);
            }
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargesListCopier.copy(recurringCharges);
        }

        @SafeVarargs
        public final void setRecurringCharges(RecurringCharge ... recurringCharges) {
            if (this.recurringCharges == null) {
                this.recurringCharges = new SdkInternalList(recurringCharges.length);
            }
            for (RecurringCharge e : recurringCharges) {
                this.recurringCharges.add(e);
            }
        }

        public final String getScope() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final void setScope(Scope scope) {
            this.scope(scope.toString());
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public ReservedInstances build() {
            return new ReservedInstances(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedInstances> {
        public Builder availabilityZone(String var1);

        public Builder duration(Long var1);

        public Builder end(Date var1);

        public Builder fixedPrice(Float var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesId(String var1);

        public Builder start(Date var1);

        public Builder state(String var1);

        public Builder state(ReservedInstanceState var1);

        public Builder usagePrice(Float var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

