/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.ReasonCodesListCopier;
import software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes;
import software.amazon.awssdk.services.ec2.model.ReportStatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReportInstanceStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReportInstanceStatusRequest> {
    private final String description;
    private final Date endTime;
    private final List<String> instances;
    private final List<String> reasonCodes;
    private final Date startTime;
    private final String status;

    private ReportInstanceStatusRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.instances = builder.instances;
        this.reasonCodes = builder.reasonCodes;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public String description() {
        return this.description;
    }

    public Date endTime() {
        return this.endTime;
    }

    public List<String> instances() {
        return this.instances;
    }

    public List<String> reasonCodes() {
        return this.reasonCodes;
    }

    public Date startTime() {
        return this.startTime;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.reasonCodes() == null ? 0 : this.reasonCodes().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest)((Object)obj);
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.reasonCodes() == null ^ this.reasonCodes() == null) {
            return false;
        }
        if (other.reasonCodes() != null && !other.reasonCodes().equals(this.reasonCodes())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.reasonCodes() != null) {
            sb.append("ReasonCodes: ").append(this.reasonCodes()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private Date endTime;
        private List<String> instances = new SdkInternalList();
        private List<String> reasonCodes = new SdkInternalList();
        private Date startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportInstanceStatusRequest model) {
            this.setDescription(model.description);
            this.setEndTime(model.endTime);
            this.setInstances(model.instances);
            this.setReasonCodes(model.reasonCodes);
            this.setStartTime(model.startTime);
            this.setStatus(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final Collection<String> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String ... instances) {
            if (this.instances == null) {
                this.instances = new SdkInternalList(instances.length);
            }
            for (String e : instances) {
                this.instances.add(e);
            }
            return this;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
        }

        @SafeVarargs
        public final void setInstances(String ... instances) {
            if (this.instances == null) {
                this.instances = new SdkInternalList(instances.length);
            }
            for (String e : instances) {
                this.instances.add(e);
            }
        }

        public final Collection<String> getReasonCodes() {
            return this.reasonCodes;
        }

        @Override
        public final Builder reasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(String ... reasonCodes) {
            if (this.reasonCodes == null) {
                this.reasonCodes = new SdkInternalList(reasonCodes.length);
            }
            for (String e : reasonCodes) {
                this.reasonCodes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(ReportInstanceReasonCodes ... reasonCodes) {
            if (this.reasonCodes == null) {
                this.reasonCodes = new SdkInternalList(reasonCodes.length);
            }
            for (ReportInstanceReasonCodes ele : reasonCodes) {
                this.reasonCodes.add(ele.toString());
            }
            return this;
        }

        public final void setReasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
        }

        @SafeVarargs
        public final void setReasonCodes(String ... reasonCodes) {
            if (this.reasonCodes == null) {
                this.reasonCodes = new SdkInternalList(reasonCodes.length);
            }
            for (String e : reasonCodes) {
                this.reasonCodes.add(e);
            }
        }

        @SafeVarargs
        public final void setReasonCodes(ReportInstanceReasonCodes ... reasonCodes) {
            if (this.reasonCodes == null) {
                this.reasonCodes = new SdkInternalList(reasonCodes.length);
            }
            for (ReportInstanceReasonCodes ele : reasonCodes) {
                this.reasonCodes.add(ele.toString());
            }
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ReportStatusType status) {
            this.status(status.toString());
        }

        public ReportInstanceStatusRequest build() {
            return new ReportInstanceStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReportInstanceStatusRequest> {
        public Builder description(String var1);

        public Builder endTime(Date var1);

        public Builder instances(Collection<String> var1);

        public Builder instances(String ... var1);

        public Builder reasonCodes(Collection<String> var1);

        public Builder reasonCodes(String ... var1);

        public Builder reasonCodes(ReportInstanceReasonCodes ... var1);

        public Builder startTime(Date var1);

        public Builder status(String var1);

        public Builder status(ReportStatusType var1);
    }
}

