/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.RequestHostIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseHostReservationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PurchaseHostReservationRequest> {
    private final String clientToken;
    private final String currencyCode;
    private final List<String> hostIdSet;
    private final String limitPrice;
    private final String offeringId;

    private PurchaseHostReservationRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.hostIdSet = builder.hostIdSet;
        this.limitPrice = builder.limitPrice;
        this.offeringId = builder.offeringId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String limitPrice() {
        return this.limitPrice;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.hostIdSet() == null ? 0 : this.hostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.limitPrice() == null ? 0 : this.limitPrice().hashCode());
        hashCode = 31 * hashCode + (this.offeringId() == null ? 0 : this.offeringId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationRequest)) {
            return false;
        }
        PurchaseHostReservationRequest other = (PurchaseHostReservationRequest)((Object)obj);
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.hostIdSet() == null ^ this.hostIdSet() == null) {
            return false;
        }
        if (other.hostIdSet() != null && !other.hostIdSet().equals(this.hostIdSet())) {
            return false;
        }
        if (other.limitPrice() == null ^ this.limitPrice() == null) {
            return false;
        }
        if (other.limitPrice() != null && !other.limitPrice().equals(this.limitPrice())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        return other.offeringId() == null || other.offeringId().equals(this.offeringId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.hostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.hostIdSet()).append(",");
        }
        if (this.limitPrice() != null) {
            sb.append("LimitPrice: ").append(this.limitPrice()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private String currencyCode;
        private List<String> hostIdSet = new SdkInternalList();
        private String limitPrice;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationRequest model) {
            this.setClientToken(model.clientToken);
            this.setCurrencyCode(model.currencyCode);
            this.setHostIdSet(model.hostIdSet);
            this.setLimitPrice(model.limitPrice);
            this.setOfferingId(model.offeringId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final void setCurrencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            if (this.hostIdSet == null) {
                this.hostIdSet = new SdkInternalList(hostIdSet.length);
            }
            for (String e : hostIdSet) {
                this.hostIdSet.add(e);
            }
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        @SafeVarargs
        public final void setHostIdSet(String ... hostIdSet) {
            if (this.hostIdSet == null) {
                this.hostIdSet = new SdkInternalList(hostIdSet.length);
            }
            for (String e : hostIdSet) {
                this.hostIdSet.add(e);
            }
        }

        public final String getLimitPrice() {
            return this.limitPrice;
        }

        @Override
        public final Builder limitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public PurchaseHostReservationRequest build() {
            return new PurchaseHostReservationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PurchaseHostReservationRequest> {
        public Builder clientToken(String var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder limitPrice(String var1);

        public Builder offeringId(String var1);
    }
}

