/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LaunchPermissionModifications
implements ToCopyableBuilder<Builder, LaunchPermissionModifications> {
    private final List<LaunchPermission> add;
    private final List<LaunchPermission> remove;

    private LaunchPermissionModifications(BuilderImpl builder) {
        this.add = builder.add;
        this.remove = builder.remove;
    }

    public List<LaunchPermission> add() {
        return this.add;
    }

    public List<LaunchPermission> remove() {
        return this.remove;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.add() == null ? 0 : this.add().hashCode());
        hashCode = 31 * hashCode + (this.remove() == null ? 0 : this.remove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermissionModifications)) {
            return false;
        }
        LaunchPermissionModifications other = (LaunchPermissionModifications)obj;
        if (other.add() == null ^ this.add() == null) {
            return false;
        }
        if (other.add() != null && !other.add().equals(this.add())) {
            return false;
        }
        if (other.remove() == null ^ this.remove() == null) {
            return false;
        }
        return other.remove() == null || other.remove().equals(this.remove());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.add() != null) {
            sb.append("Add: ").append(this.add()).append(",");
        }
        if (this.remove() != null) {
            sb.append("Remove: ").append(this.remove()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LaunchPermission> add = new SdkInternalList();
        private List<LaunchPermission> remove = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermissionModifications model) {
            this.setAdd(model.add);
            this.setRemove(model.remove);
        }

        public final Collection<LaunchPermission> getAdd() {
            return this.add;
        }

        @Override
        public final Builder add(Collection<LaunchPermission> add) {
            this.add = LaunchPermissionListCopier.copy(add);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder add(LaunchPermission ... add) {
            if (this.add == null) {
                this.add = new SdkInternalList(add.length);
            }
            for (LaunchPermission e : add) {
                this.add.add(e);
            }
            return this;
        }

        public final void setAdd(Collection<LaunchPermission> add) {
            this.add = LaunchPermissionListCopier.copy(add);
        }

        @SafeVarargs
        public final void setAdd(LaunchPermission ... add) {
            if (this.add == null) {
                this.add = new SdkInternalList(add.length);
            }
            for (LaunchPermission e : add) {
                this.add.add(e);
            }
        }

        public final Collection<LaunchPermission> getRemove() {
            return this.remove;
        }

        @Override
        public final Builder remove(Collection<LaunchPermission> remove) {
            this.remove = LaunchPermissionListCopier.copy(remove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remove(LaunchPermission ... remove) {
            if (this.remove == null) {
                this.remove = new SdkInternalList(remove.length);
            }
            for (LaunchPermission e : remove) {
                this.remove.add(e);
            }
            return this;
        }

        public final void setRemove(Collection<LaunchPermission> remove) {
            this.remove = LaunchPermissionListCopier.copy(remove);
        }

        @SafeVarargs
        public final void setRemove(LaunchPermission ... remove) {
            if (this.remove == null) {
                this.remove = new SdkInternalList(remove.length);
            }
            for (LaunchPermission e : remove) {
                this.remove.add(e);
            }
        }

        public LaunchPermissionModifications build() {
            return new LaunchPermissionModifications(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchPermissionModifications> {
        public Builder add(Collection<LaunchPermission> var1);

        public Builder add(LaunchPermission ... var1);

        public Builder remove(Collection<LaunchPermission> var1);

        public Builder remove(LaunchPermission ... var1);
    }
}

