/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.PrefixList;
import software.amazon.awssdk.services.ec2.model.PrefixListSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePrefixListsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribePrefixListsResponse> {
    private final String nextToken;
    private final List<PrefixList> prefixLists;

    private DescribePrefixListsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.prefixLists = builder.prefixLists;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<PrefixList> prefixLists() {
        return this.prefixLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.prefixLists() == null ? 0 : this.prefixLists().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsResponse)) {
            return false;
        }
        DescribePrefixListsResponse other = (DescribePrefixListsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.prefixLists() == null ^ this.prefixLists() == null) {
            return false;
        }
        return other.prefixLists() == null || other.prefixLists().equals(this.prefixLists());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.prefixLists() != null) {
            sb.append("PrefixLists: ").append(this.prefixLists()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PrefixList> prefixLists = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsResponse model) {
            this.setNextToken(model.nextToken);
            this.setPrefixLists(model.prefixLists);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PrefixList> getPrefixLists() {
            return this.prefixLists;
        }

        @Override
        public final Builder prefixLists(Collection<PrefixList> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copy(prefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(PrefixList ... prefixLists) {
            if (this.prefixLists == null) {
                this.prefixLists = new SdkInternalList(prefixLists.length);
            }
            for (PrefixList e : prefixLists) {
                this.prefixLists.add(e);
            }
            return this;
        }

        public final void setPrefixLists(Collection<PrefixList> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copy(prefixLists);
        }

        @SafeVarargs
        public final void setPrefixLists(PrefixList ... prefixLists) {
            if (this.prefixLists == null) {
                this.prefixLists = new SdkInternalList(prefixLists.length);
            }
            for (PrefixList e : prefixLists) {
                this.prefixLists.add(e);
            }
        }

        public DescribePrefixListsResponse build() {
            return new DescribePrefixListsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePrefixListsResponse> {
        public Builder nextToken(String var1);

        public Builder prefixLists(Collection<PrefixList> var1);

        public Builder prefixLists(PrefixList ... var1);
    }
}

