/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatus;
import software.amazon.awssdk.services.ec2.model.MovingAddressStatusSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMovingAddressesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMovingAddressesResponse> {
    private final List<MovingAddressStatus> movingAddressStatuses;
    private final String nextToken;

    private DescribeMovingAddressesResponse(BuilderImpl builder) {
        this.movingAddressStatuses = builder.movingAddressStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<MovingAddressStatus> movingAddressStatuses() {
        return this.movingAddressStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.movingAddressStatuses() == null ? 0 : this.movingAddressStatuses().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesResponse)) {
            return false;
        }
        DescribeMovingAddressesResponse other = (DescribeMovingAddressesResponse)((Object)obj);
        if (other.movingAddressStatuses() == null ^ this.movingAddressStatuses() == null) {
            return false;
        }
        if (other.movingAddressStatuses() != null && !other.movingAddressStatuses().equals(this.movingAddressStatuses())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.movingAddressStatuses() != null) {
            sb.append("MovingAddressStatuses: ").append(this.movingAddressStatuses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MovingAddressStatus> movingAddressStatuses = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMovingAddressesResponse model) {
            this.setMovingAddressStatuses(model.movingAddressStatuses);
            this.setNextToken(model.nextToken);
        }

        public final Collection<MovingAddressStatus> getMovingAddressStatuses() {
            return this.movingAddressStatuses;
        }

        @Override
        public final Builder movingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder movingAddressStatuses(MovingAddressStatus ... movingAddressStatuses) {
            if (this.movingAddressStatuses == null) {
                this.movingAddressStatuses = new SdkInternalList(movingAddressStatuses.length);
            }
            for (MovingAddressStatus e : movingAddressStatuses) {
                this.movingAddressStatuses.add(e);
            }
            return this;
        }

        public final void setMovingAddressStatuses(Collection<MovingAddressStatus> movingAddressStatuses) {
            this.movingAddressStatuses = MovingAddressStatusSetCopier.copy(movingAddressStatuses);
        }

        @SafeVarargs
        public final void setMovingAddressStatuses(MovingAddressStatus ... movingAddressStatuses) {
            if (this.movingAddressStatuses == null) {
                this.movingAddressStatuses = new SdkInternalList(movingAddressStatuses.length);
            }
            for (MovingAddressStatus e : movingAddressStatuses) {
                this.movingAddressStatuses.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMovingAddressesResponse build() {
            return new DescribeMovingAddressesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMovingAddressesResponse> {
        public Builder movingAddressStatuses(Collection<MovingAddressStatus> var1);

        public Builder movingAddressStatuses(MovingAddressStatus ... var1);

        public Builder nextToken(String var1);
    }
}

