/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.CustomerGatewayIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeCustomerGatewaysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeCustomerGatewaysRequest> {
    private final List<String> customerGatewayIds;
    private final List<Filter> filters;

    private DescribeCustomerGatewaysRequest(BuilderImpl builder) {
        this.customerGatewayIds = builder.customerGatewayIds;
        this.filters = builder.filters;
    }

    public List<String> customerGatewayIds() {
        return this.customerGatewayIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.customerGatewayIds() == null ? 0 : this.customerGatewayIds().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysRequest)) {
            return false;
        }
        DescribeCustomerGatewaysRequest other = (DescribeCustomerGatewaysRequest)((Object)obj);
        if (other.customerGatewayIds() == null ^ this.customerGatewayIds() == null) {
            return false;
        }
        if (other.customerGatewayIds() != null && !other.customerGatewayIds().equals(this.customerGatewayIds())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        return other.filters() == null || other.filters().equals(this.filters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.customerGatewayIds() != null) {
            sb.append("CustomerGatewayIds: ").append(this.customerGatewayIds()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> customerGatewayIds = new SdkInternalList();
        private List<Filter> filters = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysRequest model) {
            this.setCustomerGatewayIds(model.customerGatewayIds);
            this.setFilters(model.filters);
        }

        public final Collection<String> getCustomerGatewayIds() {
            return this.customerGatewayIds;
        }

        @Override
        public final Builder customerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGatewayIds(String ... customerGatewayIds) {
            if (this.customerGatewayIds == null) {
                this.customerGatewayIds = new SdkInternalList(customerGatewayIds.length);
            }
            for (String e : customerGatewayIds) {
                this.customerGatewayIds.add(e);
            }
            return this;
        }

        public final void setCustomerGatewayIds(Collection<String> customerGatewayIds) {
            this.customerGatewayIds = CustomerGatewayIdStringListCopier.copy(customerGatewayIds);
        }

        @SafeVarargs
        public final void setCustomerGatewayIds(String ... customerGatewayIds) {
            if (this.customerGatewayIds == null) {
                this.customerGatewayIds = new SdkInternalList(customerGatewayIds.length);
            }
            for (String e : customerGatewayIds) {
                this.customerGatewayIds.add(e);
            }
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            if (this.filters == null) {
                this.filters = new SdkInternalList(filters.length);
            }
            for (Filter e : filters) {
                this.filters.add(e);
            }
        }

        public DescribeCustomerGatewaysRequest build() {
            return new DescribeCustomerGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeCustomerGatewaysRequest> {
        public Builder customerGatewayIds(Collection<String> var1);

        public Builder customerGatewayIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);
    }
}

